/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.variant.writers;

import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.Utils;

public abstract class GVCFBlock
implements Locatable {
    protected final VariantContext startingVC;
    protected final int minGQ;
    protected final int maxGQ;
    protected final Allele ref;
    protected final List<Integer> DPs = new ArrayList<Integer>();
    protected int end;

    public GVCFBlock(VariantContext startingVC, int lowerGQBound, int upperGQBound) {
        Utils.nonNull(startingVC, "startingVC cannot be null");
        this.startingVC = startingVC;
        this.minGQ = lowerGQBound;
        this.maxGQ = upperGQBound;
        this.ref = startingVC.getReference();
        this.end = this.getStart() - 1;
    }

    public void add(int pos, Genotype genotype) {
        this.add(pos, pos, genotype);
    }

    public VariantContext toVariantContext(String sampleName, boolean floorBlocks) {
        VariantContextBuilder vcb = new VariantContextBuilder(this.getStartingVC());
        vcb.attributes(new LinkedHashMap(2));
        vcb.stop((long)this.getEnd());
        vcb.attribute("END", (Object)this.getEnd());
        Genotype genotype = this.createHomRefGenotype(sampleName, floorBlocks);
        return vcb.genotypes(new Genotype[]{genotype}).make();
    }

    abstract Genotype createHomRefGenotype(String var1, boolean var2);

    public abstract void add(int var1, int var2, Genotype var3);

    public boolean withinBounds(int GQ) {
        return GQ >= this.minGQ && GQ < this.maxGQ;
    }

    public int getMinDP() {
        return Collections.min(this.DPs);
    }

    public int getMedianDP() {
        return (int)Math.round(MathUtils.median(this.DPs));
    }

    int getGQUpperBound() {
        return this.maxGQ;
    }

    int getGQLowerBound() {
        return this.minGQ;
    }

    public boolean isContiguous(VariantContext vc) {
        return vc.getStart() == this.getEnd() + 1 && this.startingVC.getContig().equals(vc.getContig());
    }

    public VariantContext getStartingVC() {
        return this.startingVC;
    }

    public String getContig() {
        return this.startingVC.getContig();
    }

    public int getStart() {
        return this.startingVC.getStart();
    }

    public int getEnd() {
        return this.end;
    }

    public Allele getRef() {
        return this.ref;
    }

    public int getSize() {
        return this.getEnd() - this.getStart() + 1;
    }

    public String toString() {
        return "HomRefBlock{minGQ=" + this.minGQ + ", maxGQ=" + this.maxGQ + '}';
    }
}

