/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.variant.writers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFStandardHeaderLines;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.iterators.PushPullTransformer;
import org.broadinstitute.hellbender.utils.variant.GATKVCFHeaderLines;
import org.broadinstitute.hellbender.utils.variant.writers.GVCFBlock;
import org.broadinstitute.hellbender.utils.variant.writers.HomRefBlock;

public class GVCFBlockCombiner
implements PushPullTransformer<VariantContext> {
    final RangeMap<Integer, Range<Integer>> gqPartitions;
    final int defaultPloidy;
    final boolean floorBlocks;
    final Queue<VariantContext> toOutput = new ArrayDeque<VariantContext>();
    private int nextAvailableStart = -1;
    private String contigOfNextAvailableStart = null;
    private String sampleName = null;
    GVCFBlock currentBlock = null;

    public GVCFBlockCombiner(List<Number> gqPartitions, int defaultPloidy, boolean floorBlocks) {
        this.gqPartitions = this.parsePartitions(gqPartitions);
        this.defaultPloidy = defaultPloidy;
        this.floorBlocks = floorBlocks;
    }

    @VisibleForTesting
    RangeMap<Integer, Range<Integer>> parsePartitions(List<Number> gqPartitions) {
        Utils.nonEmpty(gqPartitions);
        Utils.containsNoNull(gqPartitions, "The list of GQ partitions contains a null integer");
        TreeRangeMap result = TreeRangeMap.create();
        int lastThreshold = 0;
        for (Number num : gqPartitions) {
            int value = num.intValue();
            if (value < 0) {
                throw new IllegalArgumentException("The list of GQ partitions contains a non-positive integer.");
            }
            if (value > 100) {
                throw new IllegalArgumentException(String.format("The value %d in the list of GQ partitions is greater than VCFConstants.MAX_GENOTYPE_QUAL + 1 = %d.", value, 100));
            }
            if (value < lastThreshold) {
                throw new IllegalArgumentException(String.format("The list of GQ partitions is out of order. Previous value is %d but the next is %d.", lastThreshold, value));
            }
            if (value == lastThreshold) {
                throw new IllegalArgumentException(String.format("The value %d appears more than once in the list of GQ partitions.", value));
            }
            result.put(Range.closedOpen((Comparable)Integer.valueOf(lastThreshold), (Comparable)Integer.valueOf(value)), (Object)Range.closedOpen((Comparable)Integer.valueOf(lastThreshold), (Comparable)Integer.valueOf(value)));
            lastThreshold = value;
        }
        if (lastThreshold <= 99) {
            result.put(Range.closedOpen((Comparable)Integer.valueOf(lastThreshold), (Comparable)Integer.valueOf(100)), (Object)Range.closedOpen((Comparable)Integer.valueOf(lastThreshold), (Comparable)Integer.valueOf(100)));
        }
        return result;
    }

    public void addRangesToHeader(VCFHeader header) {
        Utils.nonNull(header, "header cannot be null");
        header.addMetaDataLine((VCFHeaderLine)VCFStandardHeaderLines.getInfoLine((String)"END"));
        header.addMetaDataLine((VCFHeaderLine)GATKVCFHeaderLines.getFormatLine("MIN_DP"));
        for (Range partition : this.gqPartitions.asMapOfRanges().keySet()) {
            header.addMetaDataLine(GVCFBlockCombiner.rangeToVCFHeaderLine((Range<Integer>)partition));
        }
    }

    static VCFHeaderLine rangeToVCFHeaderLine(Range<Integer> genotypeQualityBand) {
        String key = String.format("GVCFBlock%d-%d", genotypeQualityBand.lowerEndpoint(), genotypeQualityBand.upperEndpoint());
        return new VCFHeaderLine(key, "minGQ=" + genotypeQualityBand.lowerEndpoint() + "(inclusive),maxGQ=" + genotypeQualityBand.upperEndpoint() + "(exclusive)");
    }

    protected VariantContext addHomRefSite(VariantContext vc, Genotype g) {
        VariantContext result;
        if (this.nextAvailableStart != -1) {
            if (vc.getStart() <= this.nextAvailableStart && vc.getContig().equals(this.contigOfNextAvailableStart) && vc.getEnd() <= this.nextAvailableStart) {
                return null;
            }
            this.nextAvailableStart = -1;
            this.contigOfNextAvailableStart = null;
        }
        if (this.genotypeCanBeMergedInCurrentBlock(g)) {
            this.currentBlock.add(vc.getStart(), vc.getAttributeAsInt("END", vc.getStart()), g);
            result = null;
        } else {
            result = this.currentBlock != null ? this.currentBlock.toVariantContext(this.sampleName, this.floorBlocks) : null;
            this.currentBlock = this.createNewBlock(vc, g);
        }
        return result;
    }

    boolean genotypeCanBeMergedInCurrentBlock(Genotype g) {
        HomRefBlock currentHomRefBlock = (HomRefBlock)this.currentBlock;
        return currentHomRefBlock != null && currentHomRefBlock.withinBounds(Math.min(g.getGQ(), 99)) && currentHomRefBlock.getPloidy() == g.getPloidy() && (currentHomRefBlock.getMinPLs() == null || !g.hasPL() || currentHomRefBlock.getMinPLs().length == g.getPL().length);
    }

    GVCFBlock createNewBlock(VariantContext vc, Genotype g) {
        int gq = g.hasGQ() ? Math.min(g.getGQ(), 99) : 0;
        Range partition = (Range)this.gqPartitions.get((Comparable)Integer.valueOf(gq));
        if (partition == null) {
            throw new GATKException("GQ " + g + " from " + vc + " didn't fit into any partition");
        }
        HomRefBlock block = new HomRefBlock(vc, (Integer)partition.lowerEndpoint(), (Integer)partition.upperEndpoint(), this.defaultPloidy);
        block.add(vc.getStart(), vc.getAttributeAsInt("END", vc.getStart()), g);
        return block;
    }

    private void emitCurrentBlock() {
        if (this.currentBlock != null) {
            this.toOutput.add(this.currentBlock.toVariantContext(this.sampleName, this.floorBlocks));
            this.currentBlock = null;
        }
    }

    @Override
    public void submit(VariantContext vc) {
        Genotype g;
        Utils.nonNull(vc);
        Utils.validateArg(vc.hasGenotypes(), "GVCF assumes that the VariantContext has genotypes");
        Utils.validateArg(vc.getGenotypes().size() == 1, () -> "GVCF assumes that the VariantContext has exactly one genotype but saw " + vc.getGenotypes().size());
        if (this.sampleName == null) {
            this.sampleName = vc.getGenotype(0).getSampleName();
        }
        if (this.currentBlock != null && !this.currentBlock.isContiguous(vc)) {
            this.emitCurrentBlock();
        }
        if ((g = vc.getGenotype(0)).isHomRef() && vc.hasAlternateAllele(Allele.NON_REF_ALLELE) && vc.isBiallelic()) {
            VariantContext maybeCompletedBand = this.addHomRefSite(vc, g);
            if (maybeCompletedBand != null) {
                this.toOutput.add(maybeCompletedBand);
            }
        } else {
            this.emitCurrentBlock();
            this.nextAvailableStart = vc.getEnd();
            this.contigOfNextAvailableStart = vc.getContig();
            this.toOutput.add(vc);
        }
    }

    @Override
    public boolean hasFinalizedItems() {
        return !this.toOutput.isEmpty();
    }

    @Override
    public List<VariantContext> consumeFinalizedItems() {
        ArrayList<VariantContext> result = new ArrayList<VariantContext>(this.toOutput);
        this.toOutput.clear();
        return result;
    }

    @Override
    public void signalEndOfInput() {
        this.emitCurrentBlock();
    }
}

