/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.variant.writers;

import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;
import java.util.List;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.variant.writers.GVCFBlockCombiner;

public class GVCFWriter
implements VariantContextWriter {
    public static final String GVCF_BLOCK = "GVCFBlock";
    final VariantContextWriter underlyingWriter;
    GVCFBlockCombiner gvcfBlockCombiner;

    public GVCFWriter(VariantContextWriter underlyingWriter, List<Number> gqPartitions, int defaultPloidy, boolean floorBlocks) {
        this.underlyingWriter = Utils.nonNull(underlyingWriter);
        this.gvcfBlockCombiner = new GVCFBlockCombiner(gqPartitions, defaultPloidy, floorBlocks);
    }

    public GVCFWriter(VariantContextWriter underlyingWriter, List<Number> gqPartitions, int defaultPloidy) {
        this(underlyingWriter, gqPartitions, defaultPloidy, false);
    }

    public void writeHeader(VCFHeader header) {
        this.gvcfBlockCombiner.addRangesToHeader(header);
        this.underlyingWriter.writeHeader(header);
    }

    public void close() {
        try {
            this.gvcfBlockCombiner.signalEndOfInput();
            this.output();
        }
        finally {
            this.underlyingWriter.close();
        }
    }

    public boolean checkError() {
        return this.underlyingWriter.checkError();
    }

    public void add(VariantContext vc) {
        this.gvcfBlockCombiner.submit(vc);
        this.output();
    }

    private void output() {
        if (this.gvcfBlockCombiner.hasFinalizedItems()) {
            this.gvcfBlockCombiner.consumeFinalizedItems().forEach(arg_0 -> ((VariantContextWriter)this.underlyingWriter).add(arg_0));
        }
    }

    public void setHeader(VCFHeader header) {
        this.gvcfBlockCombiner.addRangesToHeader(header);
        this.underlyingWriter.setHeader(header);
    }
}

