/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.variant.writers;

import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.Collections;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.walkers.variantutils.PosteriorProbabilitiesUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;
import org.broadinstitute.hellbender.utils.variant.writers.GVCFBlock;

final class HomRefBlock
extends GVCFBlock {
    private static final int HOM_REF_PL_POSITION = 0;
    private final int ploidy;
    private int[] minPLs = null;
    private int[] minPPs = null;
    private int minGQ = -1;

    public HomRefBlock(VariantContext startingVC, int lowerGQBound, int upperGQBound, int defaultPloidy) {
        super(startingVC, lowerGQBound, upperGQBound);
        Utils.nonNull(startingVC, "startingVC cannot be null");
        Utils.validateArg(upperGQBound <= 100, "upperGQBound must be <= 100");
        if (lowerGQBound > upperGQBound) {
            throw new IllegalArgumentException("bad lowerGQBound " + lowerGQBound + " as it's >= upperGQBound " + upperGQBound);
        }
        this.ploidy = startingVC.getMaxPloidy(defaultPloidy);
    }

    @Override
    Genotype createHomRefGenotype(String sampleName, boolean floorBlocks) {
        GenotypeBuilder gb = new GenotypeBuilder(sampleName, Collections.nCopies(this.getPloidy(), this.getRef()));
        gb.noAD().noPL().noAttributes();
        int[] minPLs = this.getMinPLs();
        int[] minPPs = this.getMinPPs();
        if (!floorBlocks) {
            if (minPLs != null) {
                gb.PL(minPLs);
            }
            gb.GQ(this.getMinGQ());
            gb.attribute("MIN_DP", (Object)this.getMinDP());
        } else {
            gb.GQ(this.getGQLowerBound());
        }
        gb.DP(this.getMedianDP());
        if (minPPs != null) {
            gb.attribute("PP", Utils.listFromPrimitives(minPPs));
        }
        return gb.make();
    }

    @Override
    public void add(int pos, int newEnd, Genotype genotype) {
        int i;
        Utils.nonNull(genotype, "genotype cannot be null");
        if (pos != this.end + 1) {
            throw new IllegalArgumentException("adding genotype at pos " + pos + " isn't contiguous with previous end " + this.end);
        }
        if (genotype.getPloidy() != this.ploidy) {
            throw new IllegalArgumentException("cannot add a genotype with a different ploidy: " + genotype.getPloidy() + " != " + this.ploidy);
        }
        if (!this.withinBounds(Math.min(genotype.getGQ(), 99))) {
            throw new IllegalArgumentException("cannot add a genotype with GQ=" + genotype.getGQ() + " because it's not within bounds [" + this.getGQLowerBound() + ',' + this.getGQUpperBound() + ')');
        }
        if (this.minPLs == null) {
            this.minPLs = genotype.getPL();
        } else {
            int[] pls = genotype.getPL();
            if (pls != null) {
                if (pls.length != this.minPLs.length) {
                    throw new GATKException("trying to merge different PL array sizes: " + pls.length + " != " + this.minPLs.length);
                }
                for (i = 0; i < pls.length; ++i) {
                    this.minPLs[i] = Math.min(this.minPLs[i], pls[i]);
                }
            }
        }
        if (genotype.hasExtendedAttribute("PP")) {
            if (this.minPPs == null) {
                this.minPPs = PosteriorProbabilitiesUtils.parsePosteriorsIntoPhredSpace(genotype);
            } else {
                int[] pps = PosteriorProbabilitiesUtils.parsePosteriorsIntoPhredSpace(genotype);
                if (pps.length != this.minPPs.length) {
                    throw new GATKException("trying to merge different PP array sizes: " + pps.length + " != " + this.minPPs.length);
                }
                for (i = 0; i < pps.length; ++i) {
                    this.minPPs[i] = Math.min(this.minPPs[i], pps[i]);
                }
            }
        }
        this.minGQ = this.minPPs != null ? GATKVariantContextUtils.calculateGQFromPLs(this.minPPs) : (this.minPLs != null ? GATKVariantContextUtils.calculateGQFromPLs(this.minPLs) : (this.minGQ == -1 ? genotype.getGQ() : Math.min(this.minGQ, genotype.getGQ())));
        this.end = newEnd;
        this.DPs.add(Math.max(genotype.getDP(), 0));
    }

    public int[] getMinPLs() {
        return this.minPLs;
    }

    public int[] getMinPPs() {
        return this.minPPs;
    }

    public int getPloidy() {
        return this.ploidy;
    }

    public int getMinGQ() {
        return this.minGQ;
    }
}

