/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.variant.writers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.List;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.variant.writers.GVCFBlock;
import org.broadinstitute.hellbender.utils.variant.writers.GVCFBlockCombiner;
import org.broadinstitute.hellbender.utils.variant.writers.TLODBlock;

public class SomaticGVCFBlockCombiner
extends GVCFBlockCombiner {
    @VisibleForTesting
    protected int partitionPrecision;

    public SomaticGVCFBlockCombiner(List<Number> gqPartitions, int defaultPloidy) {
        super(gqPartitions, defaultPloidy, false);
    }

    public SomaticGVCFBlockCombiner(List<Number> gqPartitions, int defaultPloidy, int partitionPrecision) {
        super(gqPartitions, defaultPloidy, false);
        this.partitionPrecision = partitionPrecision;
    }

    @VisibleForTesting
    protected static int convertLODtoInt(double LOD, int partitionPrecision) {
        return (int)Math.floor(LOD * Math.pow(10.0, partitionPrecision));
    }

    @Override
    boolean genotypeCanBeMergedInCurrentBlock(Genotype g) {
        TLODBlock currentTLODBlock = (TLODBlock)this.currentBlock;
        double TLOD = Double.parseDouble(g.getExtendedAttribute("TLOD").toString());
        return currentTLODBlock != null && currentTLODBlock.withinBounds(SomaticGVCFBlockCombiner.convertLODtoInt(TLOD, this.partitionPrecision));
    }

    @Override
    GVCFBlock createNewBlock(VariantContext vc, Genotype g) {
        double lod = Double.parseDouble(g.getExtendedAttribute("TLOD").toString());
        Range partition = (Range)this.gqPartitions.get((Comparable)Integer.valueOf(SomaticGVCFBlockCombiner.convertLODtoInt(lod, this.partitionPrecision)));
        if (partition == null) {
            throw new GATKException("LOD for genotype " + g + " from " + vc + " didn't fit into any partition");
        }
        TLODBlock block = new TLODBlock(vc, (Integer)partition.lowerEndpoint(), (Integer)partition.upperEndpoint(), this.partitionPrecision);
        block.add(vc.getStart(), g);
        return block;
    }

    @Override
    @VisibleForTesting
    RangeMap<Integer, Range<Integer>> parsePartitions(List<Number> gqPartitions) {
        this.partitionPrecision = SomaticGVCFBlockCombiner.calculatePartitionPrecision(gqPartitions);
        Utils.nonEmpty(gqPartitions);
        Utils.containsNoNull(gqPartitions, "The list of TLOD partitions contains a null integer");
        TreeRangeMap result = TreeRangeMap.create();
        int lastThreshold = Integer.MIN_VALUE;
        for (Number num : gqPartitions) {
            double value = num.doubleValue();
            int intThreshold = SomaticGVCFBlockCombiner.convertLODtoInt(value, this.partitionPrecision);
            result.put(Range.closedOpen((Comparable)Integer.valueOf(lastThreshold), (Comparable)Integer.valueOf(intThreshold)), (Object)Range.closedOpen((Comparable)Integer.valueOf(lastThreshold), (Comparable)Integer.valueOf(intThreshold)));
            lastThreshold = intThreshold;
        }
        result.put(Range.closedOpen((Comparable)Integer.valueOf(lastThreshold), (Comparable)Integer.valueOf(Integer.MAX_VALUE)), (Object)Range.closedOpen((Comparable)Integer.valueOf(lastThreshold), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
        return result;
    }

    private static int calculatePartitionPrecision(List<Number> gqPartitions) {
        double smallestDelta = Double.POSITIVE_INFINITY;
        double lastLOD = Double.NEGATIVE_INFINITY;
        for (Number num : gqPartitions) {
            double value = num.doubleValue();
            Utils.validateArg(value != lastLOD, String.format("The value %f appears more than once in the list of TLOD partitions.", value));
            Utils.validateArg(value > lastLOD, String.format("The list of TLOD partitions is out of order. Previous value is %f but the next is %f.", lastLOD, value));
            double delta = value - lastLOD;
            if (delta < smallestDelta) {
                smallestDelta = delta;
            }
            lastLOD = value;
        }
        return (int)Math.ceil(-Math.log10(smallestDelta));
    }
}

