/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.variant.writers;

import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.Collections;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.variant.writers.GVCFBlock;

final class TLODBlock
extends GVCFBlock {
    private double minBlockLOD = Double.POSITIVE_INFINITY;
    private int partitionPrecision;

    TLODBlock(VariantContext startingVC, int lowerLODBoundAsBinnedInt, int upperLODBoundAsBinnedInt, int partitionPrecision) {
        super(startingVC, (int)Math.floor(lowerLODBoundAsBinnedInt), (int)Math.floor(upperLODBoundAsBinnedInt));
        this.partitionPrecision = partitionPrecision;
    }

    private int convertLODtoInt(double LOD) {
        return (int)Math.floor(LOD * Math.pow(10.0, this.partitionPrecision));
    }

    private double convertIntToLOD(int binnedValue) {
        return (double)binnedValue / Math.pow(10.0, this.partitionPrecision);
    }

    public double getMinBlockLOD() {
        return this.minBlockLOD;
    }

    public double getLODLowerBound() {
        return this.convertIntToLOD(this.getGQLowerBound());
    }

    public double getLODUpperBound() {
        return this.convertIntToLOD(this.getGQUpperBound());
    }

    boolean withinBounds(double lod) {
        return this.withinBounds(this.convertLODtoInt(lod));
    }

    @Override
    Genotype createHomRefGenotype(String sampleName, boolean floorBlock) {
        GenotypeBuilder gb = new GenotypeBuilder(sampleName, Collections.nCopies(2, this.getRef()));
        gb.noAD().noPL().noAttributes();
        gb.attribute("TLOD", (Object)this.minBlockLOD);
        gb.DP(this.getMedianDP());
        gb.attribute("MIN_DP", (Object)this.getMinDP());
        return gb.make();
    }

    @Override
    public void add(int pos, int newEnd, Genotype genotype) {
        Utils.nonNull(genotype, "genotype cannot be null");
        Utils.validateArg(pos == this.end + 1, "adding genotype at pos " + pos + " isn't contiguous with previous end " + this.end);
        double currentLOD = Double.parseDouble(genotype.getExtendedAttribute("TLOD").toString());
        if (!this.withinBounds(currentLOD)) {
            throw new IllegalArgumentException("cannot add a genotype with LOD=" + currentLOD + " because it's not within bounds [" + this.getLODLowerBound() + ',' + this.getLODUpperBound() + ')');
        }
        if (this.minBlockLOD == Double.POSITIVE_INFINITY || currentLOD < this.minBlockLOD) {
            this.minBlockLOD = currentLOD;
        }
        this.end = newEnd;
        this.DPs.add(Math.max(genotype.getDP(), 0));
    }

    @Override
    public String toString() {
        return "TLODBlock{minLOD=" + this.getLODLowerBound() + ", maxLOD=" + this.getLODUpperBound() + '}';
    }
}

