/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.http.nio;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.IntStream;
import org.broadinstitute.http.nio.HttpFileSystem;
import org.broadinstitute.http.nio.HttpUtils;
import org.broadinstitute.http.nio.Utils;

final class HttpPath
implements Path {
    private final HttpFileSystem fs;
    private final byte[] normalizedPath;
    private volatile int[] offsets;
    private final String query;
    private final String reference;
    private final boolean absolute;

    private HttpPath(HttpFileSystem fs, String query, String reference, boolean absolute, byte ... normalizedPath) {
        this.fs = fs;
        this.query = query;
        this.reference = reference;
        this.absolute = absolute;
        this.normalizedPath = normalizedPath;
    }

    HttpPath(HttpFileSystem fs, String path, String query, String reference) {
        this(Utils.nonNull(fs, () -> "null fs"), query, reference, true, HttpPath.getNormalizedPathBytes(Utils.nonNull(path, () -> "null path"), true));
    }

    @Override
    public HttpFileSystem getFileSystem() {
        return this.fs;
    }

    @Override
    public boolean isAbsolute() {
        return this.absolute;
    }

    @Override
    public Path getRoot() {
        return new HttpPath(this.fs, null, null, true, new byte[0]);
    }

    @Override
    public Path getFileName() {
        this.initOffsets();
        if (this.offsets.length == 0) {
            return null;
        }
        return this.subpath(this.offsets.length - 1, this.offsets.length, false);
    }

    @Override
    public Path getParent() {
        this.initOffsets();
        if (this.offsets.length == 0) {
            return this.getRoot();
        }
        return this.subpath(0, this.offsets.length - 1, this.absolute);
    }

    @Override
    public int getNameCount() {
        this.initOffsets();
        return this.offsets.length;
    }

    @Override
    public Path getName(int index) {
        this.initOffsets();
        return this.subpath(index, index + 1, false);
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        this.initOffsets();
        if (beginIndex < 0 || beginIndex >= this.offsets.length || endIndex <= beginIndex || endIndex > this.offsets.length) {
            throw new IllegalArgumentException(String.format("Invalid indexes for path with %s name(s): [%s, %s]", this.getNameCount(), beginIndex, endIndex));
        }
        return this.subpath(beginIndex, endIndex, false);
    }

    private HttpPath subpath(int beginIndex, int endIndex, boolean absolute) {
        int begin = this.offsets[beginIndex];
        int end = endIndex == this.offsets.length ? this.normalizedPath.length : this.offsets[endIndex];
        byte[] newPath = Arrays.copyOfRange(this.normalizedPath, begin, end);
        return new HttpPath(this.fs, null, null, absolute, newPath);
    }

    @Override
    public boolean startsWith(Path other) {
        if (!this.getFileSystem().equals(Utils.nonNull(other, () -> "null path").getFileSystem())) {
            return false;
        }
        return this.startsWith(((HttpPath)other).normalizedPath);
    }

    @Override
    public boolean startsWith(String other) {
        Utils.nonNull(other, () -> "null other");
        return this.startsWith(HttpPath.getNormalizedPathBytes(other, false));
    }

    private boolean startsWith(byte[] other) {
        int i;
        int olen = HttpPath.getLastIndexWithoutTrailingSlash(other);
        if (olen > this.normalizedPath.length) {
            return false;
        }
        for (i = 0; i <= olen; ++i) {
            if (this.normalizedPath[i] == other[i]) continue;
            return false;
        }
        return i >= this.normalizedPath.length || this.normalizedPath[i] == 47;
    }

    @Override
    public boolean endsWith(Path other) {
        if (!this.getFileSystem().equals(Utils.nonNull(other, () -> "null path").getFileSystem())) {
            return false;
        }
        return this.endsWith(((HttpPath)other).normalizedPath, true);
    }

    @Override
    public boolean endsWith(String other) {
        Utils.nonNull(other, () -> "null other");
        return this.endsWith(HttpPath.getNormalizedPathBytes(other, false), false);
    }

    private boolean endsWith(byte[] other, boolean pathVersion) {
        int olast = HttpPath.getLastIndexWithoutTrailingSlash(other);
        int last = HttpPath.getLastIndexWithoutTrailingSlash(this.normalizedPath);
        if (olast == -1) {
            return last == -1;
        }
        if (last < olast) {
            return false;
        }
        while (olast >= 0) {
            if (other[olast] != this.normalizedPath[last]) {
                return false;
            }
            --olast;
            --last;
        }
        if (last == -1) {
            return true;
        }
        if (pathVersion) {
            return true;
        }
        return this.normalizedPath[last] == 47;
    }

    @Override
    public Path normalize() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Path resolve(Path other) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Path resolve(String other) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Path resolveSibling(Path other) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Path resolveSibling(String other) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Path relativize(Path other) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public URI toUri() {
        try {
            return new URI(this.fs.provider().getScheme(), this.fs.getAuthority(), new String(this.normalizedPath, HttpUtils.HTTP_PATH_CHARSET), this.query, this.reference);
        }
        catch (URISyntaxException e) {
            throw new IOError(e);
        }
    }

    @Override
    public Path toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        return new HttpPath(this.fs, this.query, this.reference, true, this.normalizedPath);
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException(this.getClass() + " cannot be converted to a File");
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Iterator<Path> iterator() {
        return IntStream.range(0, this.getNameCount()).mapToObj(this::getName).iterator();
    }

    @Override
    public int compareTo(Path other) {
        if (this == other) {
            return 0;
        }
        HttpPath httpOther = (HttpPath)other;
        if (this.fs.provider() != httpOther.fs.provider()) {
            throw new ClassCastException();
        }
        int comparison = this.fs.getAuthority().compareToIgnoreCase(httpOther.fs.getAuthority());
        if (comparison != 0) {
            return comparison;
        }
        int len1 = this.normalizedPath.length;
        int len2 = httpOther.normalizedPath.length;
        int n = Math.min(len1, len2);
        for (int k = 0; k < n; ++k) {
            comparison = Byte.compare(this.normalizedPath[k], httpOther.normalizedPath[k]);
            if (comparison == 0) continue;
            return comparison;
        }
        comparison = len1 - len2;
        if (comparison != 0) {
            return comparison;
        }
        comparison = Comparator.nullsFirst(String::compareTo).compare(this.query, httpOther.query);
        if (comparison != 0) {
            return comparison;
        }
        return Comparator.nullsFirst(String::compareTo).compare(this.reference, httpOther.reference);
    }

    @Override
    public boolean equals(Object other) {
        try {
            return ((HttpPath)other).absolute == this.absolute && this.compareTo((Path)other) == 0;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int h = 31 * Boolean.hashCode(this.absolute) + this.fs.hashCode();
        for (int i = 0; i < this.normalizedPath.length; ++i) {
            h = 31 * h + (this.normalizedPath[i] & 0xFF);
        }
        h = 31 * h + Objects.hash(this.query, this.reference);
        return h;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.fs.provider().getScheme()).append("://").append(this.fs.getAuthority()).append(new String(this.normalizedPath, HttpUtils.HTTP_PATH_CHARSET));
        if (this.query != null) {
            sb.append('?').append(this.query);
        }
        if (this.reference != null) {
            sb.append('#').append(this.reference);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initOffsets() {
        if (this.offsets == null) {
            int index;
            int length = HttpPath.getLastIndexWithoutTrailingSlash(this.normalizedPath);
            int count = 0;
            for (index = 0; index < length; ++index) {
                byte c = this.normalizedPath[index];
                if (c != 47) continue;
                ++count;
                ++index;
            }
            int[] result = new int[count];
            count = 0;
            for (index = 0; index < length; ++index) {
                byte c = this.normalizedPath[index];
                if (c != 47) continue;
                result[count++] = index++;
            }
            HttpPath httpPath = this;
            synchronized (httpPath) {
                if (this.offsets == null) {
                    this.offsets = result;
                }
            }
        }
    }

    private static byte[] getNormalizedPathBytes(String path, boolean checkRelative) {
        if (checkRelative && !path.isEmpty() && !path.startsWith("/")) {
            throw new InvalidPathException(path, "Relative HTTP/S path are not supported");
        }
        if ("/".equals(path) || path.isEmpty()) {
            return new byte[0];
        }
        int len = path.length();
        char prevChar = '\u0000';
        for (int i = 0; i < len; ++i) {
            char c = path.charAt(i);
            if (HttpPath.isDoubleSeparator(prevChar, c)) {
                return HttpPath.getNormalizedPathBytes(path, len, i - 1);
            }
            prevChar = HttpPath.checkNotNull(path, c);
        }
        if (prevChar == '/') {
            return HttpPath.getNormalizedPathBytes(path, len, len - 1);
        }
        return path.getBytes(HttpUtils.HTTP_PATH_CHARSET);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] getNormalizedPathBytes(String path, int len, int offset) {
        int lastOffset;
        for (lastOffset = len; lastOffset > 0 && path.charAt(lastOffset - 1) == '/'; --lastOffset) {
        }
        if (lastOffset == 0) {
            return new byte[]{47};
        }
        try (ByteArrayOutputStream os = new ByteArrayOutputStream(len);){
            if (offset > 0) {
                os.write(path.substring(0, offset).getBytes(HttpUtils.HTTP_PATH_CHARSET));
            }
            char prevChar = '\u0000';
            for (int i = offset; i < len; ++i) {
                char c = path.charAt(i);
                if (HttpPath.isDoubleSeparator(prevChar, c)) continue;
                prevChar = HttpPath.checkNotNull(path, c);
                os.write(c);
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new Utils.ShouldNotHappenException(e);
        }
    }

    private static boolean isDoubleSeparator(char prevChar, char c) {
        return c == '/' && prevChar == '/';
    }

    private static char checkNotNull(String path, char c) {
        if (c == '\u0000') {
            throw new InvalidPathException(path, "Null character not allowed in path");
        }
        return c;
    }

    private static int getLastIndexWithoutTrailingSlash(byte[] path) {
        int len = path.length - 1;
        if (len > 0 && path[len] == 47) {
            --len;
        }
        return len;
    }
}

