/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.http.nio;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import org.broadinstitute.http.nio.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpUtils {
    public static final String HTTP_PATH_SEPARATOR_STRING = "/";
    public static final char HTTP_PATH_SEPARATOR_CHAR = '/';
    public static final Charset HTTP_PATH_CHARSET = Charset.forName("UTF-8");
    private static final String HEAD_REQUEST_METHOD = "HEAD";
    private static final String RANGE_REQUEST_PROPERTY_KEY = "Range";
    private static final String RANGE_REQUEST_PROPERTY_VALUE_START = "bytes=";
    private static final String RANGE_REQUEST_PROPERTY_VALUE_SEPARATOR = "-";
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpUtils.class);

    private HttpUtils() {
    }

    public static void disconnect(URLConnection connection) {
        Utils.nonNull(connection, () -> "null URL connection");
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(URL url) throws IOException {
        Utils.nonNull(url, () -> "null url");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        try {
            conn.setRequestMethod(HEAD_REQUEST_METHOD);
            boolean bl = conn.getResponseCode() == 200;
            return bl;
        }
        catch (UnknownHostException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            conn.disconnect();
        }
    }

    public static void setRangeRequest(URLConnection connection, long start, long end) {
        Utils.nonNull(connection, () -> "Null URLConnection");
        String request = RANGE_REQUEST_PROPERTY_VALUE_START + start + RANGE_REQUEST_PROPERTY_VALUE_SEPARATOR;
        if (end != -1L) {
            request = request + end;
        }
        if (start < 0L || end < -1L || end != -1L && end < start) {
            throw new IllegalArgumentException("Invalid request: " + request);
        }
        LOGGER.debug("Request '{}' {} for {}", new Object[]{RANGE_REQUEST_PROPERTY_KEY, request, connection});
        connection.setRequestProperty(RANGE_REQUEST_PROPERTY_KEY, request);
    }
}

