/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.http.nio;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import org.broadinstitute.http.nio.HttpUtils;
import org.broadinstitute.http.nio.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class URLSeekableByteChannel
implements SeekableByteChannel {
    private static final long SKIP_DISTANCE = 8192L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final URL url;
    private long position = 0L;
    private long size = -1L;
    private URLConnection connection = null;
    private ReadableByteChannel channel = null;
    private InputStream backingStream = null;

    URLSeekableByteChannel(URL url) throws IOException {
        this.url = Utils.nonNull(url, () -> "null URL");
        this.instantiateChannel(this.position);
    }

    @Override
    public synchronized int read(ByteBuffer dst) throws IOException {
        int read = this.channel.read(dst);
        if (read != -1) {
            this.position += (long)read;
        }
        return read;
    }

    @Override
    public int write(ByteBuffer src) {
        throw new NonWritableChannelException();
    }

    @Override
    public synchronized long position() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        return this.position;
    }

    @Override
    public synchronized URLSeekableByteChannel position(long newPosition) throws IOException {
        if (newPosition < 0L) {
            throw new IllegalArgumentException("Cannot seek a negative position");
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.position != newPosition) {
            if (this.position < newPosition && newPosition - this.position < 8192L) {
                long bytesToSkip;
                long skipped;
                for (bytesToSkip = newPosition - this.position; bytesToSkip > 0L; bytesToSkip -= skipped) {
                    skipped = this.backingStream.skip(bytesToSkip);
                    if (skipped > 0L) continue;
                    throw new IOException("Failed to skip any bytes while moving from " + this.position + " to " + newPosition);
                }
                this.logger.debug("Skipped {} bytes out of {} for setting position to {} (previously on {})", new Object[]{bytesToSkip, bytesToSkip, newPosition, this.position});
            } else {
                this.close();
                this.instantiateChannel(newPosition);
            }
        }
        this.position = newPosition;
        return this;
    }

    @Override
    public synchronized long size() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.size == -1L) {
            URLConnection connection = this.url.openConnection();
            connection.connect();
            try {
                this.size = connection.getContentLengthLong();
                if (this.size == -1L) {
                    throw new IOException("Unable to retrieve content length for " + this.url);
                }
            }
            finally {
                if (connection != null) {
                    HttpUtils.disconnect(connection);
                }
            }
        }
        return this.size;
    }

    @Override
    public SeekableByteChannel truncate(long size) {
        throw new NonWritableChannelException();
    }

    @Override
    public synchronized boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public synchronized void close() throws IOException {
        this.channel.close();
        if (this.connection != null) {
            HttpUtils.disconnect(this.connection);
            this.connection = null;
        }
    }

    private synchronized void instantiateChannel(long position) throws IOException {
        try {
            if (this.connection == null) {
                this.connection = this.url.openConnection();
            }
            if (position > 0L) {
                HttpUtils.setRangeRequest(this.connection, position, -1L);
            }
            this.backingStream = new BufferedInputStream(this.connection.getInputStream());
            this.channel = Channels.newChannel(this.backingStream);
            this.position = position;
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new IOException("Failure while instantiating connection to: " + this.url.toString() + " at position: " + position, ex);
        }
    }
}

