/*
 * Decompiled with CFR 0.152.
 */
package org.brotli.dec;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.brotli.dec.BrotliRuntimeException;
import org.brotli.dec.Utils;

class BitReader {
    private static final int READ_SIZE = 4096;
    private static final int BUF_SIZE = 4160;
    private final ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4160).order(ByteOrder.LITTLE_ENDIAN);
    private final IntBuffer intBuffer = this.byteBuffer.asIntBuffer();
    private final byte[] shadowBuffer = new byte[4160];
    private InputStream input;
    private boolean endOfStreamReached;
    long accumulator;
    int bitOffset;
    private int available;
    private int tailBytes = 0;

    BitReader() {
    }

    static void readMoreInput(BitReader br) {
        int bytesRead;
        if (br.available > 9) {
            return;
        }
        if (br.endOfStreamReached) {
            if (br.available > 4) {
                return;
            }
            throw new BrotliRuntimeException("No more input");
        }
        int readOffset = br.intBuffer.position() << 2;
        System.arraycopy(br.shadowBuffer, readOffset, br.shadowBuffer, 0, bytesRead);
        try {
            int len;
            for (bytesRead = 4096 - readOffset; bytesRead < 4096; bytesRead += len) {
                len = br.input.read(br.shadowBuffer, bytesRead, 4096 - bytesRead);
                if (len != -1) continue;
                br.endOfStreamReached = true;
                Utils.fillWithZeroes(br.shadowBuffer, bytesRead, 64);
                br.tailBytes = (bytesRead += 64) & 3;
                break;
            }
        }
        catch (IOException e) {
            throw new BrotliRuntimeException("Failed to read input", e);
        }
        br.byteBuffer.clear();
        br.byteBuffer.put(br.shadowBuffer, 0, bytesRead & 0xFFFC);
        br.intBuffer.rewind();
        br.available = bytesRead >> 2;
    }

    static void checkHealth(BitReader br) {
        if (!br.endOfStreamReached) {
            return;
        }
        int unusedBytes = (br.available << 2) + (64 - br.bitOffset >> 3);
        int borrowedBytes = 64 - br.tailBytes;
        if (unusedBytes != borrowedBytes) {
            throw new BrotliRuntimeException("Read after end");
        }
    }

    static void fillBitWindow(BitReader br) {
        if (br.bitOffset >= 32) {
            br.accumulator = (long)br.intBuffer.get() << 32 | br.accumulator >>> 32;
            br.bitOffset -= 32;
            --br.available;
        }
    }

    static int readBits(BitReader br, int n) {
        BitReader.fillBitWindow(br);
        int val = (int)(br.accumulator >>> br.bitOffset) & (1 << n) - 1;
        br.bitOffset += n;
        return val;
    }

    static void init(BitReader br, InputStream input) {
        if (br.input != null) {
            throw new IllegalStateException("Bit reader already has associated input stream");
        }
        br.input = input;
        br.accumulator = 0L;
        br.intBuffer.position(1024);
        br.bitOffset = 64;
        br.available = 0;
        br.endOfStreamReached = false;
        BitReader.readMoreInput(br);
        if (br.available == 0) {
            throw new BrotliRuntimeException("Can't initialize reader");
        }
        BitReader.fillBitWindow(br);
        BitReader.fillBitWindow(br);
    }

    static void close(BitReader br) throws IOException {
        InputStream is = br.input;
        br.input = null;
        if (is != null) {
            is.close();
        }
    }

    static void jumpToByteBoundary(BitReader br) {
        int paddingBits;
        int padding = 64 - br.bitOffset & 7;
        if (padding != 0 && (paddingBits = BitReader.readBits(br, padding)) != 0) {
            throw new BrotliRuntimeException("Corrupted padding bits ");
        }
    }
}

