/*
 * Decompiled with CFR 0.152.
 */
package org.brutusin.fleadb;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.brutusin.commons.utils.Miscellaneous;
import org.brutusin.fleadb.Schema;
import org.brutusin.fleadb.impl.SchemaImpl;
import org.brutusin.json.ParseException;
import org.brutusin.json.spi.JsonCodec;
import org.brutusin.json.spi.JsonNode;

public class FleaDBInfo {
    private Schema schema;

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder("{\"jsonSchema\":");
        sb.append(this.getSchema().getJSONSChema());
        sb.append("}");
        try {
            return JsonCodec.getInstance().prettyPrint(sb.toString());
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static FleaDBInfo readFromFile(File f) throws ParseException, IOException {
        FleaDBInfo ret = new FleaDBInfo();
        String json = Miscellaneous.toString((InputStream)new FileInputStream(f), (String)"UTF-8");
        JsonNode jsonNode = JsonCodec.getInstance().parse(json);
        SchemaImpl schema = new SchemaImpl(JsonCodec.getInstance().parseSchema(jsonNode.get("jsonSchema").toString()));
        ret.setSchema(schema);
        return ret;
    }

    public static void writeToFile(FleaDBInfo fleaDBInfo, File f) throws IOException {
        Miscellaneous.writeStringToFile((File)f, (String)fleaDBInfo.toString(), (String)"UTF-8");
    }
}

