/*
 * Decompiled with CFR 0.152.
 */
package org.brutusin.fleadb.facet;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.brutusin.fleadb.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FacetMultiplicities {
    private final Map<String, Integer> facetMap = new HashMap<String, Integer>();
    private Map<String, Integer> unmodifableMap;

    private FacetMultiplicities(String facetName, int multiplicity) {
        this.and(facetName, multiplicity);
    }

    public static FacetMultiplicities set(String facetName, int multiplicity) {
        FacetMultiplicities ret = new FacetMultiplicities(facetName, multiplicity);
        return ret;
    }

    public FacetMultiplicities and(String facetName, int multiplicity) {
        this.validate(facetName, multiplicity);
        this.facetMap.put(facetName, multiplicity);
        this.unmodifableMap = null;
        return this;
    }

    private void validate(String facetName, int multiplicity) {
        if (this.facetMap.containsKey(facetName)) {
            throw new IllegalArgumentException("Facet name already registered: " + facetName);
        }
        if (multiplicity < 1) {
            throw new IllegalArgumentException("Multiplicity must be greater than 0");
        }
    }

    public Map<String, Integer> getFacetMap(Schema schema) {
        if (this.unmodifableMap == null) {
            this.unmodifableMap = Collections.unmodifiableMap(this.facetMap);
        }
        for (Map.Entry<String, Integer> entry : this.facetMap.entrySet()) {
            String facetName = entry.getKey();
            if (schema.getFacetFields().containsKey(facetName)) continue;
            throw new IllegalArgumentException("Invalid facet name: " + facetName + ". Supported values are: " + schema.getFacetFields().keySet());
        }
        return this.unmodifableMap;
    }
}

