/*
 * Decompiled with CFR 0.152.
 */
package org.brutusin.fleadb.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.FacetField;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.taxonomy.FastTaxonomyFacetCounts;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import org.brutusin.commons.Pair;
import org.brutusin.fleadb.FleaDB;
import org.brutusin.fleadb.FleaDBInfo;
import org.brutusin.fleadb.Schema;
import org.brutusin.fleadb.facet.FacetMultiplicities;
import org.brutusin.fleadb.facet.FacetResponse;
import org.brutusin.fleadb.impl.FacetResponseImpl;
import org.brutusin.fleadb.impl.FacetValueResponseImpl;
import org.brutusin.fleadb.impl.JsonTransformer;
import org.brutusin.fleadb.impl.SchemaImpl;
import org.brutusin.fleadb.pagination.Paginator;
import org.brutusin.fleadb.pagination.PaginatorImpl;
import org.brutusin.fleadb.query.BooleanQuery;
import org.brutusin.fleadb.sort.Sort;
import org.brutusin.json.ParseException;
import org.brutusin.json.spi.JsonNode;
import org.brutusin.json.spi.JsonSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GenericFleaDB
implements FleaDB<JsonNode> {
    public static final Version LUCENE_VERSION = Version.LUCENE_4_10_3;
    private static final String DESCRIPTOR_FILE_NAME = "flea.json";
    private static final String RECORD_INDEX_SUBFOLDER_NAME = "record-index";
    private static final String TAXONOMY_INDEX_SUBFOLDER_NAME = "taxonomy-index";
    private final FleaDBInfo dsInfo;
    private final JsonTransformer transformer;
    private final Directory indexDir;
    private final Directory facetDir;
    private final File indexFolder;
    private FacetsConfig facetsConfig;
    private boolean closed = false;
    private File infoFile;
    private volatile IndexSearcher indexSearcher;
    private volatile IndexWriter indexWriter;
    private volatile TaxonomyReader taxonomyReader;
    private volatile TaxonomyWriter taxonomyWriter;

    public GenericFleaDB(JsonSchema jsonSchema) throws IOException {
        this(null, jsonSchema);
    }

    public GenericFleaDB(File indexFolder) throws IOException {
        this(indexFolder, null);
    }

    public GenericFleaDB(File indexFolder, JsonSchema jsonSchema) throws IOException {
        try {
            this.indexFolder = indexFolder;
            SchemaImpl schema = jsonSchema == null ? null : new SchemaImpl(jsonSchema);
            if (indexFolder == null) {
                if (schema == null) {
                    throw new IllegalArgumentException("In-memory datasources require an schema");
                }
                this.dsInfo = new FleaDBInfo();
                this.dsInfo.setSchema(schema);
                this.indexDir = new RAMDirectory();
                this.facetDir = new RAMDirectory();
            } else {
                this.infoFile = new File(indexFolder, DESCRIPTOR_FILE_NAME);
                if (indexFolder.exists()) {
                    this.dsInfo = this.readFleaDBInfo();
                    if (this.dsInfo == null) {
                        throw new IllegalArgumentException("Unable to read schema from specified index folder '" + indexFolder + "'");
                    }
                    if (schema != null && !this.dsInfo.getSchema().getJSONSChema().equals(schema.getJSONSChema())) {
                        throw new IllegalArgumentException("Specified schema is incompatible with current datasource for index at '" + indexFolder + "'");
                    }
                } else {
                    if (schema == null) {
                        throw new IllegalArgumentException("Index folder does not exist '" + indexFolder.getAbsolutePath() + "'");
                    }
                    this.dsInfo = new FleaDBInfo();
                    this.dsInfo.setSchema(schema);
                    this.writeFleaDBInfo();
                }
                this.indexDir = FSDirectory.open((File)new File(indexFolder, RECORD_INDEX_SUBFOLDER_NAME));
                this.facetDir = FSDirectory.open((File)new File(indexFolder, TAXONOMY_INDEX_SUBFOLDER_NAME));
            }
            this.transformer = new JsonTransformer(this.dsInfo.getSchema());
            this.facetsConfig = new FacetsConfig();
            Map<String, Boolean> facets = this.getSchema().getFacetFields();
            for (Map.Entry<String, Boolean> entry : facets.entrySet()) {
                String facet = entry.getKey();
                Boolean multievaluated = entry.getValue();
                this.facetsConfig.setMultiValued(facet, multievaluated.booleanValue());
            }
        }
        catch (Throwable th) {
            this.close();
            if (th instanceof IOException) {
                throw (IOException)th;
            }
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            throw (Error)th;
        }
    }

    public File getIndexFolder() {
        return this.indexFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexSearcher getIndexSearcher() throws IOException {
        if (this.indexSearcher == null) {
            GenericFleaDB genericFleaDB = this;
            synchronized (genericFleaDB) {
                if (this.indexSearcher == null) {
                    this.indexSearcher = new IndexSearcher((IndexReader)DirectoryReader.open((Directory)this.indexDir));
                }
            }
        }
        return this.indexSearcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexWriter getIndexWriter() throws IOException {
        if (this.indexWriter == null) {
            GenericFleaDB genericFleaDB = this;
            synchronized (genericFleaDB) {
                if (this.indexWriter == null) {
                    IndexWriterConfig config = new IndexWriterConfig(LUCENE_VERSION, null);
                    config.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
                    this.indexWriter = new IndexWriter(this.indexDir, config);
                }
            }
        }
        return this.indexWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaxonomyReader getTaxonomyReader() throws IOException {
        if (this.taxonomyReader == null) {
            GenericFleaDB genericFleaDB = this;
            synchronized (genericFleaDB) {
                if (this.taxonomyReader == null) {
                    this.taxonomyReader = new DirectoryTaxonomyReader(this.facetDir);
                }
            }
        }
        return this.taxonomyReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaxonomyWriter getTaxonomyWriter() throws IOException {
        if (this.taxonomyWriter == null) {
            GenericFleaDB genericFleaDB = this;
            synchronized (genericFleaDB) {
                if (this.taxonomyWriter == null) {
                    this.taxonomyWriter = new DirectoryTaxonomyWriter(this.facetDir, IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
                }
            }
        }
        return this.taxonomyWriter;
    }

    protected final FleaDBInfo getFleaDBInfo() {
        return this.dsInfo;
    }

    @Override
    public synchronized void close() {
        try {
            if (this.closed) {
                throw new IllegalStateException("Datasource has been closed already");
            }
            this.closed = true;
            if (this.taxonomyReader != null) {
                this.taxonomyReader.close();
            }
            if (this.taxonomyWriter != null) {
                this.taxonomyWriter.close();
            }
            if (this.indexSearcher != null) {
                this.indexSearcher.getIndexReader().close();
            }
            if (this.indexWriter != null) {
                this.indexWriter.close();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public JsonNode getSingleResult(org.brutusin.fleadb.query.Query q) {
        Paginator<JsonNode> paginator = this.query(q, null);
        if (paginator.getTotalHits() > 1) {
            throw new IllegalArgumentException("Query returned more than 1 results");
        }
        return paginator.getFirstElement();
    }

    @Override
    public final Paginator<JsonNode> query(org.brutusin.fleadb.query.Query q) {
        return this.query(q, null);
    }

    @Override
    public final Paginator<JsonNode> query(org.brutusin.fleadb.query.Query q, Sort sort) {
        try {
            this.verifyNotClosed();
            return new PaginatorImpl<JsonNode>(this.getIndexSearcher(), this.transformer, q.getLuceneQuery(this.getSchema()), sort == null ? null : sort.getLuceneSort(this.getSchema()));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public final List<FacetResponse> getFacetValues(org.brutusin.fleadb.query.Query q, int maxFacetValues) {
        this.verifyNotClosed();
        if (this.getSchema().getFacetFields().isEmpty()) {
            return null;
        }
        FacetMultiplicities facetMultiplicities = null;
        for (Map.Entry<String, Boolean> entry : this.getSchema().getFacetFields().entrySet()) {
            String facetName = entry.getKey();
            if (facetMultiplicities == null) {
                facetMultiplicities = FacetMultiplicities.set(facetName, maxFacetValues);
                continue;
            }
            facetMultiplicities.and(facetName, maxFacetValues);
        }
        return this.getFacetValues(q, facetMultiplicities);
    }

    @Override
    public int getNumFacetValues(org.brutusin.fleadb.query.Query q, String facetName) {
        List<FacetResponse> frs = this.getFacetValues(q, FacetMultiplicities.set(facetName, 1));
        return frs.get(0).getNumFacetValues();
    }

    @Override
    public final List<FacetResponse> getFacetValues(org.brutusin.fleadb.query.Query q, FacetMultiplicities facetMultiplicities) {
        this.verifyNotClosed();
        if (facetMultiplicities == null) {
            return null;
        }
        try {
            ArrayList<FacetResponse> ret = new ArrayList<FacetResponse>();
            FacetsCollector facetCollector = new FacetsCollector();
            this.getIndexSearcher().search(q.getLuceneQuery(this.getSchema()), (Collector)facetCollector);
            FacetsConfig config = new FacetsConfig();
            FastTaxonomyFacetCounts facets = new FastTaxonomyFacetCounts(this.getTaxonomyReader(), config, facetCollector);
            Map<String, Integer> facetMap = facetMultiplicities.getFacetMap(this.getSchema());
            for (Map.Entry<String, Integer> entry : facetMap.entrySet()) {
                FacetResponseImpl fr;
                String facetName = entry.getKey();
                Integer multiplicity = entry.getValue();
                FacetResult res = facets.getTopChildren(multiplicity.intValue(), facetName, new String[0]);
                if (res != null) {
                    fr = new FacetResponseImpl(facetName);
                    fr.setNumFacetValues(res.childCount);
                    ret.add(fr);
                    LabelAndValue[] lvs = res.labelValues;
                    for (int j = 0; j < lvs.length; ++j) {
                        LabelAndValue lv = lvs[j];
                        FacetValueResponseImpl fvresp = new FacetValueResponseImpl(lv.label, lv.value.doubleValue());
                        fr.getFacetValues().add(fvresp);
                    }
                    continue;
                }
                fr = new FacetResponseImpl(facetName);
                fr.setNumFacetValues(0);
                ret.add(fr);
            }
            return ret;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public final List<FacetResponse> getFacetValuesStartingWith(String facetName, String prefix, org.brutusin.fleadb.query.Query q, int max) {
        double exactMultiplicity;
        this.verifyNotClosed();
        BooleanQuery bq = new BooleanQuery();
        bq.add(q, BooleanClause.Occur.MUST);
        List<FacetResponse> startingResponse = this.getFacetValues((org.brutusin.fleadb.query.Query)bq, FacetMultiplicities.set(facetName, max));
        if (prefix != null && (exactMultiplicity = this.getFacetValueMultiplicity(facetName, prefix, q)) > 0.0) {
            FacetValueResponseImpl exactMatch = new FacetValueResponseImpl(prefix, exactMultiplicity);
            startingResponse.get(0).getFacetValues().remove(exactMatch);
            startingResponse.get(0).getFacetValues().add(0, exactMatch);
        }
        return startingResponse;
    }

    @Override
    public final double getFacetValueMultiplicity(String facetName, String facetValue, org.brutusin.fleadb.query.Query q) {
        this.verifyNotClosed();
        BooleanQuery bq = new BooleanQuery();
        bq.add(q, BooleanClause.Occur.MUST);
        bq.add(org.brutusin.fleadb.query.Query.createTermQuery(facetName, facetValue), BooleanClause.Occur.MUST);
        Paginator<JsonNode> pag = this.query(bq, null);
        return pag.getTotalHits();
    }

    @Override
    public final Schema getSchema() {
        return this.dsInfo.getSchema();
    }

    @Override
    public final void delete(org.brutusin.fleadb.query.Query q) {
        try {
            this.verifyNotClosed();
            this.getIndexWriter().deleteDocuments(new Query[]{q.getLuceneQuery(this.getSchema())});
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public final void commit() {
        try {
            this.verifyNotClosed();
            this.getTaxonomyWriter().commit();
            this.getIndexWriter().commit();
            this.refresh();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public final void store(JsonNode entity) {
        try {
            this.verifyNotClosed();
            Pair<Document, List<FacetField>> pair = this.transformer.entityToDocument(entity);
            Document doc = (Document)pair.getElement1();
            List facetFields = (List)pair.getElement2();
            if (facetFields != null) {
                for (int i = 0; i < facetFields.size(); ++i) {
                    boolean multievaluated;
                    String facetName = ((FacetField)facetFields.get((int)i)).dim;
                    boolean bl = multievaluated = facetName.contains("[*]") || facetName.contains("[#]");
                    if (multievaluated) {
                        this.facetsConfig.setMultiValued(facetName, multievaluated);
                    }
                    doc.add((IndexableField)facetFields.get(i));
                }
            }
            this.getIndexWriter().addDocument((Iterable)this.facetsConfig.build(this.getTaxonomyWriter(), doc));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void verifyNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("Datasource has been closed");
        }
    }

    public void optimize() throws IOException {
        this.verifyNotClosed();
        this.getIndexWriter().forceMergeDeletes();
        this.getIndexWriter().forceMerge(1);
        this.optimizeFacetIndex();
        this.commit();
    }

    private void writeFleaDBInfo() throws IOException {
        if (this.infoFile != null) {
            FleaDBInfo.writeToFile(this.dsInfo, this.infoFile);
        }
    }

    private FleaDBInfo readFleaDBInfo() throws IOException, ParseException {
        if (this.infoFile != null) {
            return FleaDBInfo.readFromFile(this.infoFile);
        }
        return null;
    }

    private synchronized void optimizeFacetIndex() throws IOException {
    }

    private synchronized void refresh() {
        this.indexSearcher = null;
        this.taxonomyReader = null;
    }
}

