/*
 * Decompiled with CFR 0.152.
 */
package org.brutusin.fleadb.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.facet.FacetField;
import org.apache.lucene.index.IndexableField;
import org.brutusin.commons.Pair;
import org.brutusin.fleadb.DocTransformer;
import org.brutusin.fleadb.Schema;
import org.brutusin.json.ValidationException;
import org.brutusin.json.spi.Expression;
import org.brutusin.json.spi.JsonCodec;
import org.brutusin.json.spi.JsonNode;
import org.brutusin.json.spi.JsonSchema;
import org.brutusin.json.util.LazyJsonNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonTransformer
implements DocTransformer<JsonNode> {
    private static final FieldType NON_INDEXED_TYPE = new FieldType();
    private static final String OBJECT_FIELD_NAME = "$json";
    private final Schema schema;
    private final JsonSchema jsonSchema;

    public JsonTransformer(Schema schema) {
        this.schema = schema;
        try {
            this.jsonSchema = schema != null ? schema.getJSONSChema() : null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Pair<Document, List<FacetField>> entityToDocument(JsonNode jsonNode) {
        if (jsonNode == null) {
            return null;
        }
        try {
            this.jsonSchema.validate(jsonNode);
        }
        catch (ValidationException e) {
            throw new RuntimeException("Error transforming entity: " + jsonNode, e);
        }
        Document doc = new Document();
        doc.add((IndexableField)new Field(OBJECT_FIELD_NAME, jsonNode.toString(), NON_INDEXED_TYPE));
        Pair ret = new Pair();
        ret.setElement1((Object)doc);
        Pair<List<IndexableField>, List<FacetField>> indexTerms = this.getIndexTerms(jsonNode);
        ret.setElement2(indexTerms.getElement2());
        List indexFields = (List)indexTerms.getElement1();
        for (IndexableField field : indexFields) {
            doc.add(field);
        }
        return ret;
    }

    private Pair<List<IndexableField>, List<FacetField>> getIndexTerms(JsonNode jsonNode) {
        JsonNode projectedNode;
        Expression exp;
        Pair ret = new Pair();
        ArrayList<IndexableField> indexFields = new ArrayList<IndexableField>();
        ret.setElement1(indexFields);
        ArrayList<FacetField> facets = new ArrayList<FacetField>();
        ret.setElement2(facets);
        Map<String, JsonNode.Type> fields = this.schema.getIndexFields();
        for (Map.Entry<String, JsonNode.Type> entry : fields.entrySet()) {
            String indexField = entry.getKey();
            exp = JsonCodec.getInstance().compile(indexField);
            projectedNode = exp.projectNode(jsonNode);
            if (projectedNode == null) continue;
            this.addLuceneIndexFields(indexField, indexFields, projectedNode, exp.projectSchema(this.jsonSchema));
        }
        Map<String, Boolean> facetFields = this.schema.getFacetFields();
        for (String facetField : facetFields.keySet()) {
            exp = JsonCodec.getInstance().compile(facetField);
            projectedNode = exp.projectNode(jsonNode);
            if (projectedNode == null) continue;
            this.addLuceneFacets(facetField, facets, projectedNode);
        }
        return ret;
    }

    private void addLuceneFacets(String facetField, List<FacetField> list, JsonNode node) {
        JsonNode.Type type = node.getNodeType();
        if (type == JsonNode.Type.ARRAY) {
            for (int i = 0; i < node.getSize(); ++i) {
                this.addLuceneFacets(facetField, list, node.get(i));
            }
        } else if (type == JsonNode.Type.OBJECT) {
            Iterator properties = node.getProperties();
            while (properties.hasNext()) {
                String propName = (String)properties.next();
                list.add(new FacetField(facetField, new String[]{propName}));
            }
        } else if (type == JsonNode.Type.STRING) {
            list.add(new FacetField(facetField, new String[]{node.asString()}));
        } else if (type == JsonNode.Type.BOOLEAN) {
            list.add(new FacetField(facetField, new String[]{node.asString()}));
        } else {
            throw new UnsupportedOperationException("Node type " + type + " not supported for facet field " + facetField);
        }
    }

    private void addLuceneIndexFields(String indexField, List<IndexableField> list, JsonNode node, JsonSchema nodeSchema) {
        JsonNode.Type type = nodeSchema.getSchemaType();
        if (type == JsonNode.Type.ARRAY) {
            for (int i = 0; i < node.getSize(); ++i) {
                this.addLuceneIndexFields(indexField, list, node.get(i), nodeSchema.getItemSchema());
            }
        } else if (type == JsonNode.Type.OBJECT) {
            Iterator properties = node.getProperties();
            while (properties.hasNext()) {
                String propName = (String)properties.next();
                list.add((IndexableField)new StringField(indexField, propName, Field.Store.NO));
            }
        } else if (type == JsonNode.Type.STRING) {
            list.add((IndexableField)new StringField(indexField, node.asString(), Field.Store.NO));
        } else if (type == JsonNode.Type.BOOLEAN) {
            list.add((IndexableField)new StringField(indexField, node.asString(), Field.Store.NO));
        } else if (type == JsonNode.Type.INTEGER) {
            list.add((IndexableField)new LongField(indexField, node.asLong().longValue(), Field.Store.NO));
        } else if (type == JsonNode.Type.NUMBER) {
            list.add((IndexableField)new DoubleField(indexField, node.asDouble().doubleValue(), Field.Store.NO));
        } else {
            throw new UnsupportedOperationException("Node type " + type + " not supported for index field " + indexField);
        }
    }

    @Override
    public JsonNode documentToEntity(Document doc) {
        return new LazyJsonNode(doc.get(OBJECT_FIELD_NAME));
    }

    static {
        NON_INDEXED_TYPE.setIndexed(false);
        NON_INDEXED_TYPE.setStored(true);
    }
}

