/*
 * Decompiled with CFR 0.152.
 */
package org.brutusin.fleadb.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.brutusin.fleadb.FleaDB;
import org.brutusin.fleadb.FleaDBInfo;
import org.brutusin.fleadb.Schema;
import org.brutusin.fleadb.facet.FacetMultiplicities;
import org.brutusin.fleadb.facet.FacetResponse;
import org.brutusin.fleadb.impl.GenericFleaDB;
import org.brutusin.fleadb.pagination.Paginator;
import org.brutusin.fleadb.query.Query;
import org.brutusin.fleadb.sort.Sort;
import org.brutusin.json.ParseException;
import org.brutusin.json.spi.JsonCodec;
import org.brutusin.json.spi.JsonNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectFleaDB<E>
implements FleaDB<E> {
    private final GenericFleaDB genericFleaDB;
    private final Class<E> clazz;

    public ObjectFleaDB(Class<E> clazz) throws IOException {
        this(null, clazz);
    }

    public ObjectFleaDB(File indexFolder, Class<E> clazz) throws IOException {
        this.genericFleaDB = new GenericFleaDB(indexFolder, JsonCodec.getInstance().getSchema(clazz));
        this.clazz = clazz;
    }

    public File getIndexFolder() {
        return this.genericFleaDB.getIndexFolder();
    }

    protected final FleaDBInfo getFleaDBInfo() {
        return this.genericFleaDB.getFleaDBInfo();
    }

    @Override
    public synchronized void close() {
        this.genericFleaDB.close();
    }

    @Override
    public E getSingleResult(Query q) {
        return (E)JsonCodec.getInstance().load(this.genericFleaDB.getSingleResult(q), this.clazz);
    }

    @Override
    public final Paginator<E> query(Query q) {
        return this.query(q, null);
    }

    @Override
    public final Paginator<E> query(Query q, Sort sort) {
        final Paginator<JsonNode> paginator = this.genericFleaDB.query(q, sort);
        return new Paginator<E>(){

            @Override
            public int getTotalHits() {
                return paginator.getTotalHits();
            }

            @Override
            public int getTotalPages(int pageSize) {
                return paginator.getTotalPages(pageSize);
            }

            @Override
            public List<E> getPage(int pageNum, int pageSize) {
                try {
                    List page = paginator.getPage(pageNum, pageSize);
                    ArrayList<Object> ret = new ArrayList<Object>(page.size());
                    for (JsonNode jsonNode : page) {
                        ret.add(JsonCodec.getInstance().parse(jsonNode.toString(), ObjectFleaDB.this.clazz));
                    }
                    return ret;
                }
                catch (ParseException ex) {
                    throw new RuntimeException();
                }
            }

            @Override
            public E getFirstElement() {
                JsonNode firstElement = (JsonNode)paginator.getFirstElement();
                try {
                    return JsonCodec.getInstance().parse(firstElement.toString(), ObjectFleaDB.this.clazz);
                }
                catch (ParseException ex) {
                    throw new RuntimeException();
                }
            }
        };
    }

    @Override
    public final List<FacetResponse> getFacetValues(Query q, int maxFacetValues) {
        return this.genericFleaDB.getFacetValues(q, maxFacetValues);
    }

    @Override
    public final List<FacetResponse> getFacetValues(Query q, FacetMultiplicities facets) {
        return this.genericFleaDB.getFacetValues(q, facets);
    }

    @Override
    public int getNumFacetValues(Query q, String facetName) {
        return this.genericFleaDB.getNumFacetValues(q, facetName);
    }

    @Override
    public final List<FacetResponse> getFacetValuesStartingWith(String facetName, String prefix, Query q, int max) {
        return this.genericFleaDB.getFacetValuesStartingWith(facetName, prefix, q, max);
    }

    @Override
    public final double getFacetValueMultiplicity(String facetName, String facetValue, Query q) {
        return this.genericFleaDB.getFacetValueMultiplicity(facetName, facetValue, q);
    }

    @Override
    public final Schema getSchema() {
        return this.genericFleaDB.getSchema();
    }

    @Override
    public final void delete(Query q) {
        this.genericFleaDB.delete(q);
    }

    @Override
    public final void commit() {
        this.genericFleaDB.commit();
    }

    @Override
    public final void store(E entity) {
        try {
            this.genericFleaDB.store(JsonCodec.getInstance().parse(JsonCodec.getInstance().transform(entity)));
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void optimize() throws IOException {
        this.genericFleaDB.optimize();
    }
}

