/*
 * Decompiled with CFR 0.152.
 */
package org.brutusin.fleadb.impl;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.brutusin.fleadb.Schema;
import org.brutusin.json.ParseException;
import org.brutusin.json.annotations.IndexableProperty;
import org.brutusin.json.spi.JsonNode;
import org.brutusin.json.spi.JsonSchema;
import org.brutusin.json.util.JsonNodeVisitor;
import org.brutusin.json.util.JsonSchemaUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SchemaImpl
implements Schema {
    private final JsonSchema jsonSchema;
    private Map<String, JsonNode.Type> indexFields;
    private Map<String, Boolean> facetFields;

    public SchemaImpl(JsonSchema jsonSchema) throws ParseException {
        this.jsonSchema = jsonSchema;
        this.initFields();
    }

    private void initFields() {
        this.indexFields = new LinkedHashMap<String, JsonNode.Type>();
        this.facetFields = new LinkedHashMap<String, Boolean>();
        SchemaImpl.accept(this.jsonSchema, new JsonNodeVisitor(){

            private void add(String name, JsonNode.Type type, IndexableProperty.IndexMode mode) {
                SchemaImpl.this.indexFields.put(name, type);
                if (mode == IndexableProperty.IndexMode.facet) {
                    boolean multievaluated = name.contains("[*]") || name.contains("[#]");
                    SchemaImpl.this.facetFields.put(name, multievaluated);
                }
            }

            private void add(String name, JsonNode.Type type, IndexableProperty.IndexMode mode, boolean multievaluated) {
                SchemaImpl.this.indexFields.put(name, type);
                if (mode == IndexableProperty.IndexMode.facet) {
                    SchemaImpl.this.facetFields.put(name, multievaluated);
                }
            }

            public void visit(String name, JsonNode schema) {
                JsonNode indexProperty = schema.get("index");
                if (indexProperty != null) {
                    IndexableProperty.IndexMode mode = IndexableProperty.IndexMode.valueOf((String)indexProperty.asString());
                    JsonNode.Type type = JsonNode.Type.valueOf((String)schema.get("type").asString().toUpperCase());
                    if (type == JsonNode.Type.OBJECT) {
                        JsonNode.Type valueType = JsonSchemaUtils.getMapValueType((JsonNode)schema);
                        if (valueType != null) {
                            if (valueType != JsonNode.Type.OBJECT) {
                                this.add(name, JsonNode.Type.STRING, mode, true);
                                this.add(name + "[*]", valueType, mode);
                            } else {
                                this.add(name, JsonNode.Type.STRING, mode, true);
                            }
                        }
                    } else if (type == JsonNode.Type.ARRAY) {
                        JsonNode.Type valueType = JsonSchemaUtils.getArrayValueType((JsonNode)schema);
                        if (valueType != null) {
                            this.add(name + "[#]", valueType, mode);
                        }
                    } else {
                        this.add(name, type, mode);
                    }
                }
            }
        });
        LinkedHashSet<String> parentMapNames = new LinkedHashSet<String>();
        for (Map.Entry<String, JsonNode.Type> entry : this.indexFields.entrySet()) {
            String name = entry.getKey();
            SchemaImpl.addParentMapNamesToList(name, parentMapNames);
        }
        for (String parentMapName : parentMapNames) {
            if (this.indexFields.containsKey(parentMapName)) continue;
            this.indexFields.put(parentMapName, JsonNode.Type.STRING);
        }
    }

    @Override
    public JsonSchema getJSONSChema() {
        return this.jsonSchema;
    }

    @Override
    public Map<String, JsonNode.Type> getIndexFields() {
        return this.indexFields;
    }

    @Override
    public Map<String, Boolean> getFacetFields() {
        return this.facetFields;
    }

    public void setFacetFields(Map<String, Boolean> facetFields) {
        this.facetFields = facetFields;
    }

    private static void addParentMapNamesToList(String name, Set<String> set) {
        String[] tokens = name.split("\\[\\*\\]");
        if (tokens == null || tokens.length == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            if (i > 0) {
                sb.append("[*]");
            }
            sb.append(tokens[i]);
            set.add(sb.toString());
        }
    }

    private static void accept(JsonSchema rootSchema, JsonNodeVisitor ... visitors) {
        SchemaImpl.accept("$", (JsonNode)rootSchema, visitors);
    }

    private static void accept(String name, JsonNode schema, JsonNodeVisitor ... visitors) {
        JsonNode typeNode;
        if (schema == null) {
            return;
        }
        if (schema.getNodeType() == JsonNode.Type.OBJECT && (typeNode = schema.get("type")) != null && typeNode.getNodeType() == JsonNode.Type.STRING) {
            JsonNode itemsNode;
            String type = typeNode.asString();
            for (int i = 0; i < visitors.length; ++i) {
                JsonNodeVisitor visitor = visitors[i];
                visitor.visit(name, schema);
            }
            if ("object".equals(type)) {
                JsonNode additionalPropertiesNode;
                JsonNode propertiesNode = schema.get("properties");
                if (propertiesNode != null && propertiesNode.getNodeType() == JsonNode.Type.OBJECT) {
                    Iterator ps = propertiesNode.getProperties();
                    while (ps.hasNext()) {
                        String prop = (String)ps.next();
                        SchemaImpl.accept(name + (name.isEmpty() ? "" : ".") + prop, propertiesNode.get(prop), visitors);
                    }
                }
                if ((additionalPropertiesNode = schema.get("additionalProperties")) != null && additionalPropertiesNode.getNodeType() == JsonNode.Type.OBJECT) {
                    SchemaImpl.accept(name + "[*]", additionalPropertiesNode, visitors);
                }
            } else if ("array".equals(type) && (itemsNode = schema.get("items")) != null && itemsNode.getNodeType() == JsonNode.Type.OBJECT) {
                SchemaImpl.accept(name + "[#]", itemsNode, visitors);
            }
        }
    }
}

