/*
 * Decompiled with CFR 0.152.
 */
package org.brutusin.fleadb.pagination;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.brutusin.fleadb.DocTransformer;
import org.brutusin.fleadb.pagination.Paginator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaginatorImpl<E>
implements Paginator<E> {
    private final IndexSearcher searcher;
    private final Query q;
    private final Sort sort;
    private final DocTransformer<E> transformer;
    private Integer totalHits;

    public PaginatorImpl(IndexSearcher searcher, DocTransformer<E> transformer, Query q, Sort sort) {
        if (sort == null) {
            sort = Sort.INDEXORDER;
        }
        this.searcher = searcher;
        this.q = q;
        this.sort = sort;
        this.transformer = transformer;
    }

    @Override
    public E getFirstElement() {
        return this.getPage(1, 1).get(0);
    }

    @Override
    public int getTotalHits() {
        if (this.totalHits == null) {
            try {
                TopFieldCollector documentCollector = TopFieldCollector.create((Sort)this.sort, (int)1, null, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
                this.searcher.search(this.q, (Collector)documentCollector);
                this.totalHits = documentCollector.getTotalHits();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.totalHits;
    }

    @Override
    public int getTotalPages(int pageSize) {
        return (int)PaginatorImpl.getTotalPages(pageSize, this.getTotalHits());
    }

    @Override
    public List<E> getPage(int pageNum, int pageSize) {
        if (pageNum < 1) {
            throw new IllegalArgumentException("pageNum must be greater than 0");
        }
        if (pageNum > this.getTotalPages(pageSize)) {
            throw new IllegalArgumentException("pageNum (" + pageNum + ") exceeds pageSize (" + pageSize + ")");
        }
        TopDocs topDocs = null;
        try {
            for (int page = 1; page <= pageNum; ++page) {
                FieldDoc memento = topDocs == null ? null : (FieldDoc)topDocs.scoreDocs[topDocs.scoreDocs.length - 1];
                topDocs = this.queryDocuments(pageSize, memento);
            }
            ArrayList<E> ret = new ArrayList<E>(topDocs.scoreDocs.length);
            for (int i = 0; i < topDocs.scoreDocs.length; ++i) {
                FieldDoc fieldDoc = (FieldDoc)topDocs.scoreDocs[i];
                Document doc = this.searcher.doc(fieldDoc.doc);
                ret.add(this.transformer.documentToEntity(doc));
            }
            return ret;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private TopDocs queryDocuments(int pageSize, FieldDoc memento) throws IOException {
        TopFieldCollector documentCollector = TopFieldCollector.create((Sort)this.sort, (int)pageSize, (FieldDoc)memento, (boolean)true, (boolean)false, (boolean)false, (boolean)false);
        this.searcher.search(this.q, (Collector)documentCollector);
        this.totalHits = documentCollector.getTotalHits();
        return documentCollector.topDocs(0, pageSize);
    }

    public IndexSearcher getSearcher() {
        return this.searcher;
    }

    public Query getQ() {
        return this.q;
    }

    public Sort getSort() {
        return this.sort;
    }

    public DocTransformer<E> getTransformer() {
        return this.transformer;
    }

    private static long getTotalPages(int pageSize, long totalRecords) {
        long r = totalRecords % (long)pageSize;
        if (r == 0L) {
            return totalRecords / (long)pageSize;
        }
        return totalRecords / (long)pageSize + 1L;
    }
}

