/*
 * Decompiled with CFR 0.152.
 */
package org.brutusin.fleadb.query;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.BytesRef;
import org.brutusin.fleadb.Schema;
import org.brutusin.json.spi.JsonNode;

public abstract class Query {
    public static final Query MATCH_ALL_DOCS_QUERY = new Query(){
        private final org.apache.lucene.search.Query luceneQuery = new MatchAllDocsQuery();

        public org.apache.lucene.search.Query getLuceneQuery(Schema schema) {
            return this.luceneQuery;
        }
    };

    Query() {
    }

    public static Query createNumericRangeQuery(final String field, final double min, final double max, final boolean minInclusive, final boolean maxInclusive) {
        return new Query(){

            public org.apache.lucene.search.Query getLuceneQuery(Schema schema) {
                Query.validateType(field, schema, JsonNode.Type.NUMBER);
                return NumericRangeQuery.newDoubleRange((String)field, (Double)min, (Double)max, (boolean)minInclusive, (boolean)maxInclusive);
            }
        };
    }

    public static Query createIntegerRangeQuery(final String field, final long min, final long max, final boolean minInclusive, final boolean maxInclusive) {
        return new Query(){

            public org.apache.lucene.search.Query getLuceneQuery(Schema schema) {
                Query.validateType(field, schema, JsonNode.Type.INTEGER);
                return NumericRangeQuery.newLongRange((String)field, (Long)min, (Long)max, (boolean)minInclusive, (boolean)maxInclusive);
            }
        };
    }

    public static Query createTermRangeQuery(final String field, final String lower, final String upper, final boolean minInclusive, final boolean maxInclusive) {
        return new Query(){

            public org.apache.lucene.search.Query getLuceneQuery(Schema schema) {
                Query.validateType(field, schema, JsonNode.Type.STRING);
                return new TermRangeQuery(field, new BytesRef((CharSequence)lower), new BytesRef((CharSequence)upper), minInclusive, maxInclusive);
            }
        };
    }

    public static Query createTermQuery(final String field, final String value) {
        return new Query(){

            public org.apache.lucene.search.Query getLuceneQuery(Schema schema) {
                Query.validateType(field, schema, JsonNode.Type.STRING);
                return new TermQuery(new Term(field, value));
            }
        };
    }

    public static Query createWildcardQuery(final String field, final String value) {
        return new Query(){

            public org.apache.lucene.search.Query getLuceneQuery(Schema schema) {
                Query.validateType(field, schema, JsonNode.Type.STRING);
                return new WildcardQuery(new Term(field, value));
            }
        };
    }

    public static Query createPrefixQuery(final String field, final String value) {
        return new Query(){

            public org.apache.lucene.search.Query getLuceneQuery(Schema schema) {
                Query.validateType(field, schema, JsonNode.Type.STRING);
                return new PrefixQuery(new Term(field, value));
            }
        };
    }

    public static Query createFuzzyQuery(final String field, final String value) {
        return new Query(){

            public org.apache.lucene.search.Query getLuceneQuery(Schema schema) {
                Query.validateType(field, schema, JsonNode.Type.STRING);
                return new FuzzyQuery(new Term(field, value));
            }
        };
    }

    public static Query createRegExpQuery(final String field, final String value) {
        return new Query(){

            public org.apache.lucene.search.Query getLuceneQuery(Schema schema) {
                Query.validateType(field, schema, JsonNode.Type.STRING);
                return new RegexpQuery(new Term(field, value));
            }
        };
    }

    public abstract org.apache.lucene.search.Query getLuceneQuery(Schema var1);

    private static void validateType(String field, Schema schema, JsonNode.Type allowedType) {
        JsonNode.Type type = schema.getIndexFields().get(field);
        if (type == null) {
            throw new IllegalArgumentException("Unknown query field '" + field + "' found. Supported field are: " + schema.getIndexFields().keySet());
        }
        if (type != allowedType) {
            throw new IllegalArgumentException("Field " + field + " type error. Expected: " + allowedType + " , found: " + type);
        }
    }
}

