/*
 * Decompiled with CFR 0.152.
 */
package org.brutusin.fleadb.sort;

import java.util.ArrayList;
import java.util.List;
import org.brutusin.fleadb.Schema;
import org.brutusin.fleadb.sort.SortField;

public class Sort {
    private final List<SortField> sortFields = new ArrayList<SortField>();

    public static Sort by(String field) {
        return new Sort(field);
    }

    public static Sort by(SortField sortField) {
        return new Sort(sortField);
    }

    public static Sort by(String field, boolean reverse) {
        return new Sort(field, reverse);
    }

    private Sort(String field) {
        this(field, false);
    }

    private Sort(String field, boolean reverse) {
        this(new SortField(field, reverse));
    }

    private Sort(SortField sortField) {
        this.sortFields.add(sortField);
    }

    public Sort thenBy(String field) {
        return this.thenBy(field, false);
    }

    public Sort thenBy(String field, boolean reverse) {
        return this.thenBy(new SortField(field, reverse));
    }

    public Sort thenBy(SortField sortField) {
        this.sortFields.add(sortField);
        return this;
    }

    public org.apache.lucene.search.Sort getLuceneSort(Schema schema) {
        org.apache.lucene.search.Sort ret = new org.apache.lucene.search.Sort();
        org.apache.lucene.search.SortField[] sfs = new org.apache.lucene.search.SortField[this.sortFields.size()];
        for (int i = 0; i < this.sortFields.size(); ++i) {
            SortField sortField = this.sortFields.get(i);
            sfs[i] = sortField.getLuceneSortField(schema);
        }
        ret.setSort(sfs);
        return ret;
    }
}

