/*
 * Decompiled with CFR 0.152.
 */
package org.brutusin.fleadb.sort;

import org.apache.lucene.search.SortField;
import org.brutusin.fleadb.Schema;
import org.brutusin.json.spi.JsonNode;

public class SortField {
    private final String field;
    private final boolean reverse;

    public SortField(String field, boolean reverse) {
        this.field = field;
        this.reverse = reverse;
    }

    public org.apache.lucene.search.SortField getLuceneSortField(Schema schema) {
        SortField.Type type;
        JsonNode.Type jsonType = schema.getIndexFields().get(this.field);
        if (jsonType == null) {
            throw new IllegalArgumentException("Unknown sort field '" + this.field + "' found. Supported field are: " + schema.getIndexFields().keySet());
        }
        switch (jsonType) {
            case BOOLEAN: 
            case STRING: {
                type = SortField.Type.STRING;
                break;
            }
            case NUMBER: {
                type = SortField.Type.DOUBLE;
                break;
            }
            case INTEGER: {
                type = SortField.Type.LONG;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return new org.apache.lucene.search.SortField(this.field, type, this.reverse);
    }
}

