/*
 * Decompiled with CFR 0.152.
 */
package org.brutusin.wava;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.brutusin.commons.utils.Miscellaneous;
import org.brutusin.commons.utils.ProcessUtils;
import org.brutusin.wava.env.WavaTemp;

public class Utils {
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static final File LOCK_FILE = new File(WavaTemp.getInstance().getTemp(), ".lock");

    public static List<String> parseEventLine(String line) {
        ArrayList<String> ret = new ArrayList<String>();
        int start = 0;
        boolean inString = false;
        for (int i = 0; i < line.length(); ++i) {
            if (line.charAt(i) == '\"' && (i == 0 || line.charAt(i - 1) != '\\')) {
                boolean bl = inString = !inString;
            }
            if (inString || line.charAt(i) != ':') continue;
            ret.add(line.substring(start, i));
            start = i + 1;
        }
        if (start < line.length()) {
            ret.add(line.substring(start));
        }
        return ret;
    }

    public static FileLock tryWavaLock() throws IOException {
        return Utils.tryLock(LOCK_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileLock tryLock(File f) throws IOException {
        File file = f;
        synchronized (file) {
            if (!f.exists()) {
                Miscellaneous.createFile((String)f.getAbsolutePath());
            }
            RandomAccessFile raf = new RandomAccessFile(f, "rws");
            return raf.getChannel().tryLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCoreRunning() throws IOException {
        File file = LOCK_FILE;
        synchronized (file) {
            FileLock lock = Utils.tryWavaLock();
            if (lock != null) {
                lock.release();
            }
            return lock == null;
        }
    }

    public static int getJVMPid() {
        try {
            String[] cmd = new String[]{"/bin/bash", "-c", "echo $PPID"};
            return Integer.valueOf(ProcessUtils.executeProcess((String[])cmd));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

