/*
 * Decompiled with CFR 0.152.
 */
package org.brutusin.wava;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.brutusin.wava.Utils;
import org.brutusin.wava.WavaNotRunningException;
import org.brutusin.wava.env.EnvEntry;
import org.brutusin.wava.input.CancelInput;
import org.brutusin.wava.input.ExtendedSubmitInput;
import org.brutusin.wava.input.GroupInput;
import org.brutusin.wava.input.Input;
import org.brutusin.wava.input.SubmitInput;
import org.brutusin.wava.io.EventListener;
import org.brutusin.wava.io.LineListener;
import org.brutusin.wava.io.OpName;
import org.brutusin.wava.io.RequestExecutor;
import org.brutusin.wava.io.RetCode;

public class WavaClient {
    private final RequestExecutor executor = new RequestExecutor();

    public void submit(SubmitInput input, InputStream stdinStream, OutputStream stdoutStream, LineListener stderrListener, EventListener eventListener) throws WavaNotRunningException {
        try {
            Integer retCode;
            ExtendedSubmitInput esi = new ExtendedSubmitInput(input);
            String parentId = System.getenv(EnvEntry.WAVA_JOB_ID.name());
            if (parentId != null) {
                esi.setParentId(Integer.valueOf(parentId));
            }
            if ((retCode = this.executor.executeRequest(OpName.submit, esi, stdinStream, stdoutStream, stderrListener, eventListener)).intValue() == RetCode.CORE_NOT_RUNNING.getCode()) {
                throw new WavaNotRunningException();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String executeCommand(RequestExecutor executor, OpName opName, Input input) throws WavaNotRunningException {
        ByteArrayOutputStream stdoutOs = new ByteArrayOutputStream();
        final StringBuilder sb = new StringBuilder();
        LineListener stderrListener = new LineListener(){

            @Override
            public void onNewLine(String line) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(line);
            }
        };
        try {
            Integer retCode = executor.executeRequest(opName, input, null, stdoutOs, stderrListener, null);
            if (retCode.intValue() == RetCode.CORE_NOT_RUNNING.getCode()) {
                throw new WavaNotRunningException();
            }
            if (retCode != 0) {
                throw new RuntimeException(sb.toString());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return stdoutOs.toString();
    }

    public String executeGroupCommand(GroupInput input) throws WavaNotRunningException {
        return WavaClient.executeCommand(this.executor, OpName.group, input);
    }

    public String cancelJobCommand(CancelInput input) throws WavaNotRunningException {
        return WavaClient.executeCommand(this.executor, OpName.cancel, input);
    }

    public static boolean isSchedulerRunning() {
        try {
            return Utils.isCoreRunning();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

