/*
 * Decompiled with CFR 0.152.
 */
package org.brutusin.wava.cfg;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.brutusin.commons.utils.Miscellaneous;
import org.brutusin.json.spi.JsonCodec;
import org.brutusin.wava.cfg.GroupCfg;
import org.brutusin.wava.cfg.ProcessCfg;
import org.brutusin.wava.cfg.SchedulerCfg;
import org.brutusin.wava.cfg.UICfg;
import org.brutusin.wava.cfg.impl.ConfigImpl;
import org.brutusin.wava.env.WavaHome;

public class Config {
    private final File tempFolder;
    private static volatile Config instance;
    private final ConfigImpl impl;

    private Config() {
        try {
            File cfgFile = new File(WavaHome.getInstance().getFile(), "cfg/wava.json");
            if (!cfgFile.exists()) {
                throw new RuntimeException("Config file not found " + cfgFile.getAbsolutePath());
            }
            String str = Miscellaneous.toString((InputStream)new FileInputStream(cfgFile), (String)"UTF-8");
            this.impl = (ConfigImpl)JsonCodec.getInstance().parse(Config.replaceEnvEntries(str), ConfigImpl.class);
            this.tempFolder = this.impl.getTempFolder() != null ? new File(this.impl.getTempFolder() + "/" + WavaHome.getInstance().getId()) : null;
        }
        catch (Throwable th) {
            throw new Error(th);
        }
    }

    private static String replaceEnvEntries(String str) {
        StringBuilder sb = new StringBuilder(str);
        for (String envEntry : System.getenv().keySet()) {
            int i;
            String entryName = "$" + envEntry;
            while ((i = sb.indexOf(entryName)) >= 0) {
                sb.replace(i, i + entryName.length(), System.getenv().get(envEntry));
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Config getInstance() {
        if (instance != null) return instance;
        Class<Config> clazz = Config.class;
        synchronized (Config.class) {
            if (instance != null) return instance;
            instance = new Config();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public SchedulerCfg getSchedulerCfg() {
        return this.impl.getSchedulerCfg();
    }

    public ProcessCfg getProcessCfg() {
        return this.impl.getProcessCfg();
    }

    public GroupCfg getGroupCfg() {
        return this.impl.getGroupCfg();
    }

    public UICfg getuICfg() {
        return this.impl.getuICfg();
    }

    public File getTempFolder() {
        return this.tempFolder;
    }
}

