/*
 * Decompiled with CFR 0.152.
 */
package org.brutusin.wava.env;

import java.io.File;
import org.brutusin.wava.env.EnvEntry;
import org.brutusin.wava.env.WavaHomeNotSetError;

public class WavaHome {
    private static volatile WavaHome instance;
    private final File file;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WavaHome getInstance() {
        if (instance != null) return instance;
        Class<WavaHome> clazz = WavaHome.class;
        synchronized (WavaHome.class) {
            if (instance != null) return instance;
            instance = new WavaHome();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private WavaHome() {
        String wavaHome = System.getenv(EnvEntry.WAVA_HOME.name());
        if (wavaHome == null) {
            throw new WavaHomeNotSetError();
        }
        this.file = new File(wavaHome);
    }

    public File getFile() {
        return this.file;
    }

    private static final String removeLeadingAndTrailingSlashes(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public String getId() {
        return "wava[" + WavaHome.removeLeadingAndTrailingSlashes(this.file.getAbsolutePath()).replace("/", ".") + "]";
    }
}

