/*
 * Decompiled with CFR 0.152.
 */
package org.brutusin.wava.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.brutusin.commons.Bean;
import org.brutusin.commons.utils.Miscellaneous;
import org.brutusin.commons.utils.ProcessUtils;
import org.brutusin.json.spi.JsonCodec;
import org.brutusin.wava.Utils;
import org.brutusin.wava.env.WavaTemp;
import org.brutusin.wava.input.Input;
import org.brutusin.wava.io.Event;
import org.brutusin.wava.io.EventListener;
import org.brutusin.wava.io.LineListener;
import org.brutusin.wava.io.NamedPipe;
import org.brutusin.wava.io.OpName;

public class RequestExecutor {
    private static final Logger LOGGER = Logger.getLogger(RequestExecutor.class.getName());
    private static final File COUNTER_FILE = new File(WavaTemp.getInstance().getTemp(), "state/.seq");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer executeRequest(OpName opName, Input input, final InputStream stdinStream, final OutputStream stdoutStream, final LineListener stderrListener, final EventListener eventListener) throws IOException {
        long id = Miscellaneous.getGlobalAutoIncremental((File)COUNTER_FILE);
        String json = JsonCodec.getInstance().transform((Object)input);
        File streamRoot = new File(WavaTemp.getInstance().getTemp(), "streams/" + id);
        Miscellaneous.createDirectory((File)streamRoot);
        final File stdinNamedPipe = new File(streamRoot, NamedPipe.stdin.name());
        final File eventsNamedPipe = new File(streamRoot, NamedPipe.events.name());
        final File stdoutNamedPipe = new File(streamRoot, NamedPipe.stdout.name());
        final File stderrNamedPipe = new File(streamRoot, NamedPipe.stderr.name());
        try {
            ProcessUtils.createPOSIXNamedPipes((File[])new File[]{stdinNamedPipe, eventsNamedPipe, stderrNamedPipe, stdoutNamedPipe});
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        final Bean retCode = new Bean();
        final Bean stdinStreamBean = new Bean();
        final Bean eventsStreamBean = new Bean();
        final Bean stdoutStreamBean = new Bean();
        final Bean stderrStreamBean = new Bean();
        final Bean timeoutBean = new Bean();
        Thread stdinThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                FileOutputStream os = null;
                try {
                    os = new FileOutputStream(stdinNamedPipe);
                    Bean bean = timeoutBean;
                    synchronized (bean) {
                        if (timeoutBean.getValue() == null) {
                            timeoutBean.setValue((Object)false);
                        } else if (((Boolean)timeoutBean.getValue()).booleanValue()) {
                            return;
                        }
                    }
                    stdinStreamBean.setValue((Object)os);
                    if (stdinStream == null) return;
                    Miscellaneous.pipeSynchronously((InputStream)stdinStream, (boolean)true, (OutputStream[])new OutputStream[]{os});
                    return;
                }
                catch (Throwable th) {
                    LOGGER.log(Level.SEVERE, th.getMessage(), th);
                    return;
                }
                finally {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException ex) {
                            LOGGER.log(Level.SEVERE, null, ex);
                        }
                    }
                }
            }
        };
        stdinThread.setDaemon(true);
        stdinThread.start();
        Thread eventsThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                FileInputStream is = null;
                try {
                    String line;
                    is = new FileInputStream(eventsNamedPipe);
                    Bean bean = timeoutBean;
                    synchronized (bean) {
                        if (timeoutBean.getValue() == null) {
                            timeoutBean.setValue((Object)false);
                        } else if (((Boolean)timeoutBean.getValue()).booleanValue()) {
                            return;
                        }
                    }
                    eventsStreamBean.setValue((Object)is);
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    while ((line = br.readLine()) != null) {
                        String value;
                        List<String> tokens = Utils.parseEventLine(line);
                        Event evt = Event.valueOf(tokens.get(1));
                        if (tokens.size() > 2) {
                            value = tokens.get(2);
                            if (evt == Event.retcode) {
                                retCode.setValue((Object)Integer.valueOf(value));
                            }
                        } else {
                            value = null;
                        }
                        if (eventListener == null) continue;
                        eventListener.onEvent(evt, value, Long.valueOf(tokens.get(0)));
                    }
                    return;
                }
                catch (Throwable th) {
                    LOGGER.log(Level.SEVERE, th.getMessage(), th);
                    return;
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ex) {
                            LOGGER.log(Level.SEVERE, null, ex);
                        }
                    }
                }
            }
        };
        eventsThread.start();
        Thread outThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                FileInputStream is = null;
                try {
                    is = new FileInputStream(stdoutNamedPipe);
                    Bean bean = timeoutBean;
                    synchronized (bean) {
                        if (timeoutBean.getValue() == null) {
                            timeoutBean.setValue((Object)false);
                        } else if (((Boolean)timeoutBean.getValue()).booleanValue()) {
                            return;
                        }
                    }
                    stdoutStreamBean.setValue((Object)is);
                    Miscellaneous.pipeSynchronously((InputStream)is, (boolean)true, (OutputStream[])new OutputStream[]{stdoutStream});
                    return;
                }
                catch (Throwable th) {
                    LOGGER.log(Level.SEVERE, th.getMessage(), th);
                    return;
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ex) {
                            LOGGER.log(Level.SEVERE, null, ex);
                        }
                    }
                }
            }
        };
        outThread.start();
        Thread errThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                FileInputStream is = null;
                try {
                    String line;
                    is = new FileInputStream(stderrNamedPipe);
                    Bean bean = timeoutBean;
                    synchronized (bean) {
                        if (timeoutBean.getValue() == null) {
                            timeoutBean.setValue((Object)false);
                        } else if (((Boolean)timeoutBean.getValue()).booleanValue()) {
                            return;
                        }
                    }
                    stderrStreamBean.setValue((Object)is);
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    while ((line = br.readLine()) != null) {
                        if (stderrListener == null) continue;
                        stderrListener.onNewLine(line);
                    }
                    return;
                }
                catch (Throwable th) {
                    LOGGER.log(Level.SEVERE, th.getMessage(), th);
                    return;
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ex) {
                            LOGGER.log(Level.SEVERE, null, ex);
                        }
                    }
                }
            }
        };
        errThread.start();
        Thread timeoutThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Thread.sleep(10000L);
                    Bean bean = timeoutBean;
                    synchronized (bean) {
                        if (timeoutBean.getValue() == null) {
                            timeoutBean.setValue((Object)true);
                            try {
                                new FileOutputStream(eventsNamedPipe).close();
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            try {
                                new FileOutputStream(stdoutNamedPipe).close();
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            try {
                                new FileOutputStream(stderrNamedPipe).close();
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            try {
                                new FileInputStream(stdinNamedPipe).close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
        };
        timeoutThread.setDaemon(true);
        timeoutThread.start();
        File tempFile = new File(WavaTemp.getInstance().getTemp(), "temp/" + id + "-" + (Object)((Object)opName));
        File requestFile = new File(WavaTemp.getInstance().getTemp(), "request/" + id + "-" + (Object)((Object)opName));
        Files.write(tempFile.toPath(), json.getBytes(), new OpenOption[0]);
        Files.move(tempFile.toPath(), requestFile.toPath(), new CopyOption[0]);
        try {
            errThread.join();
            eventsThread.join();
            outThread.join();
        }
        catch (InterruptedException i) {
        }
        finally {
            if (stdinStreamBean.getValue() != null) {
                try {
                    ((FileOutputStream)stdinStreamBean.getValue()).close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
            if (eventsStreamBean.getValue() != null) {
                try {
                    ((FileInputStream)eventsStreamBean.getValue()).close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
            if (stdoutStreamBean.getValue() != null) {
                try {
                    ((FileInputStream)stdoutStreamBean.getValue()).close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
            if (stderrStreamBean.getValue() != null) {
                try {
                    ((FileInputStream)stderrStreamBean.getValue()).close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
        return (Integer)retCode.getValue();
    }
}

