/*
 * Decompiled with CFR 0.152.
 */
package org.brutusin.wava.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

public class JobSet {
    private final HashMap<Integer, Key> keyMap = new HashMap();
    private final TreeSet<Key> queueTree = new TreeSet();
    private final TreeSet<Key> runningTree = new TreeSet();

    public QueueIterator getQueue() {
        final Iterator<Key> it = this.queueTree.iterator();
        return new QueueIterator(){
            private Key last;

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Integer next() {
                this.last = (Key)it.next();
                return this.last.getId();
            }

            @Override
            public void moveToRunning() {
                it.remove();
                JobSet.this.runningTree.add(this.last);
            }

            @Override
            public void remove() {
                it.remove();
                JobSet.this.keyMap.remove(this.last.getId());
            }
        };
    }

    public RunningIterator getRunning() {
        final Iterator<Key> it = this.runningTree.iterator();
        return new RunningIterator(){
            private Key last;

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Integer next() {
                this.last = (Key)it.next();
                return this.last.getId();
            }

            @Override
            public void remove() {
                it.remove();
                JobSet.this.keyMap.remove(this.last.getId());
            }
        };
    }

    private Key getKey(int id) {
        Key key = this.keyMap.get(id);
        if (key == null) {
            throw new IllegalArgumentException("Id " + id + " is not in job set");
        }
        return key;
    }

    public synchronized void queue(int id, int majorPriority, int minorPriority) {
        if (this.keyMap.containsKey(id)) {
            throw new IllegalArgumentException("Id " + id + " already is in job set");
        }
        Key key = new Key(id, majorPriority, minorPriority);
        this.keyMap.put(id, key);
        this.queueTree.add(key);
    }

    public synchronized void remove(int id) {
        Key key = this.keyMap.remove(id);
        if (key == null) {
            return;
        }
        if (!this.queueTree.remove(key)) {
            this.runningTree.remove(key);
        }
    }

    public synchronized void run(int id) {
        Key key = this.getKey(id);
        if (!this.queueTree.remove(key)) {
            throw new IllegalArgumentException("Id " + id + " is not queued");
        }
        this.runningTree.add(key);
    }

    public synchronized void setPriority(int id, int majorPriority, int minorPriority) {
        TreeSet<Key> tree;
        Key key = this.getKey(id);
        if (key.getMajorPriority() == majorPriority && key.getMinorPriority() == minorPriority) {
            return;
        }
        if (this.queueTree.remove(key)) {
            tree = this.queueTree;
        } else if (this.runningTree.remove(key)) {
            tree = this.runningTree;
        } else {
            throw new AssertionError();
        }
        key.setMajorPriority(majorPriority);
        key.setMinorPriority(minorPriority);
        tree.add(key);
    }

    public synchronized int countQueued() {
        return this.queueTree.size();
    }

    public synchronized int countRunning() {
        return this.runningTree.size();
    }

    public synchronized State getState(int id) {
        Key key = this.keyMap.get(id);
        if (key == null) {
            return null;
        }
        if (this.queueTree.contains(key)) {
            return State.queued;
        }
        if (this.runningTree.contains(key)) {
            return State.running;
        }
        throw new AssertionError();
    }

    public static interface RunningIterator
    extends Iterator<Integer> {
    }

    public static interface QueueIterator
    extends Iterator<Integer> {
        public void moveToRunning();
    }

    public class Key
    implements Comparable<Key> {
        private final int id;
        private int majorPriority;
        private int minorPriority;

        public Key(int id, int majorPriority, int minorPriority) {
            this.majorPriority = majorPriority;
            this.minorPriority = minorPriority;
            this.id = id;
        }

        public int getMajorPriority() {
            return this.majorPriority;
        }

        public void setMajorPriority(int majorPriority) {
            this.majorPriority = majorPriority;
        }

        public int getMinorPriority() {
            return this.minorPriority;
        }

        public void setMinorPriority(int minorPriority) {
            this.minorPriority = minorPriority;
        }

        public int getId() {
            return this.id;
        }

        @Override
        public int compareTo(Key o) {
            int ret = Integer.compare(this.majorPriority, o.majorPriority);
            if (ret == 0 && (ret = Integer.compare(this.minorPriority, o.minorPriority)) == 0) {
                ret = Integer.compare(this.id, o.id);
            }
            return ret;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return this.id == other.id;
        }

        public int hashCode() {
            return this.id;
        }
    }

    public static enum State {
        queued,
        running;

    }
}

