/*
 * Decompiled with CFR 0.152.
 */
package org.brutusin.wava.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.brutusin.commons.utils.ErrorHandler;
import org.brutusin.commons.utils.Miscellaneous;
import org.brutusin.json.spi.JsonCodec;
import org.brutusin.wava.core.JobSet;
import org.brutusin.wava.core.cfg.Config;
import org.brutusin.wava.core.cfg.GroupCfg;
import org.brutusin.wava.core.io.Event;
import org.brutusin.wava.core.io.PeerChannel;
import org.brutusin.wava.core.plug.LinuxCommands;
import org.brutusin.wava.core.plug.NicenessHandler;
import org.brutusin.wava.core.plug.PromiseHandler;
import org.brutusin.wava.input.CancelInput;
import org.brutusin.wava.input.GroupInput;
import org.brutusin.wava.input.SubmitInput;
import org.brutusin.wava.utils.ANSICode;
import org.brutusin.wava.utils.NonRootUserException;
import org.brutusin.wava.utils.RetCode;

public class Scheduler {
    public static final String DEFAULT_GROUP_NAME = "default";
    public static final int EVICTION_ETERNAL = -1;
    private static final Logger LOGGER = Logger.getLogger(Scheduler.class.getName());
    private final JobSet jobSet = new JobSet();
    private final Map<Integer, JobInfo> jobMap = new HashMap<Integer, JobInfo>();
    private final Map<Integer, ProcessInfo> processMap = new HashMap<Integer, ProcessInfo>();
    private final Map<String, GroupInfo> groupMap = new HashMap<String, GroupInfo>();
    private final ThreadGroup threadGroup = new ThreadGroup(Scheduler.class.getName());
    private final AtomicInteger jobCounter = new AtomicInteger();
    private final AtomicInteger groupCounter = new AtomicInteger();
    private final Thread processingThread;
    private String jobList;
    private final long maxManagedRss;
    private final String runningUser = LinuxCommands.getInstance().getRunningUser();
    private boolean closed;

    public Scheduler() throws NonRootUserException, IOException, InterruptedException {
        if (!this.runningUser.equals("root")) {
            throw new NonRootUserException();
        }
        if (Config.getInstance().getSchedulerCfg().getMaxTotalRSSBytes() > 0) {
            this.maxManagedRss = Config.getInstance().getSchedulerCfg().getMaxTotalRSSBytes();
        } else {
            try {
                this.maxManagedRss = LinuxCommands.getInstance().getSystemRSSMemory();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.createGroupInfo(DEFAULT_GROUP_NAME, this.runningUser, 0, -1);
        GroupCfg.Group[] predefinedGroups = Config.getInstance().getGroupCfg().getPredefinedGroups();
        if (predefinedGroups != null) {
            for (GroupCfg.Group group : predefinedGroups) {
                this.createGroupInfo(group.getName(), this.runningUser, group.getPriority(), group.getTimeToIdleSeconds());
            }
        }
        this.processingThread = new Thread(this.threadGroup, "processingThread"){

            @Override
            public void run() {
                while (!Thread.interrupted()) {
                    try {
                        Thread.sleep(Config.getInstance().getSchedulerCfg().getPollingSecs() * 1000);
                        Scheduler.this.refresh();
                    }
                    catch (Throwable th) {
                        LOGGER.log(Level.SEVERE, null, th);
                        if (!(th instanceof InterruptedException)) continue;
                        break;
                    }
                }
            }
        };
        this.processingThread.setDaemon(true);
        this.processingThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GroupInfo createGroupInfo(String name, String user, int priority, int timetoIdleSeconds) {
        JobSet jobSet = this.jobSet;
        synchronized (jobSet) {
            if (!this.groupMap.containsKey(name)) {
                GroupInfo gi = new GroupInfo(name, user, timetoIdleSeconds);
                gi.setPriority(priority);
                this.groupMap.put(gi.getGroupName(), gi);
                return gi;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] getPIds() {
        JobSet jobSet = this.jobSet;
        synchronized (jobSet) {
            int[] ret = new int[this.jobSet.countRunning()];
            JobSet.RunningIterator running = this.jobSet.getRunning();
            int i = 0;
            while (running.hasNext()) {
                Integer id = (Integer)running.next();
                ProcessInfo pi = this.processMap.get(id);
                if (pi != null) {
                    ret[i++] = pi.getPid();
                    continue;
                }
                ret[i++] = -1;
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getMaxPromisedMemory() {
        JobSet jobSet = this.jobSet;
        synchronized (jobSet) {
            long sum = 0L;
            for (ProcessInfo pi : this.processMap.values()) {
                sum += pi.getJobInfo().getSubmitChannel().getRequest().getMaxRSS();
            }
            return sum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanStalePeers() throws InterruptedException {
        JobSet jobSet = this.jobSet;
        synchronized (jobSet) {
            Integer id;
            Iterator<Integer> it = this.jobSet.getQueue();
            while (it.hasNext()) {
                id = (Integer)it.next();
                JobInfo ji = this.jobMap.get(id);
                if (ji.getSubmitChannel().ping()) continue;
                it.remove();
                this.jobMap.remove(id);
                GroupInfo gi = this.groupMap.get(ji.getSubmitChannel().getRequest().getGroupName());
                gi.getJobs().remove(id);
                try {
                    ji.getSubmitChannel().close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
            it = this.jobSet.getRunning();
            while (it.hasNext()) {
                id = it.next();
                ProcessInfo pi = this.processMap.get(id);
                if (pi == null || pi.getJobInfo().getSubmitChannel().ping()) continue;
                try {
                    LinuxCommands.getInstance().killTree(pi.getPid());
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() throws IOException, InterruptedException {
        JobSet jobSet = this.jobSet;
        synchronized (jobSet) {
            Integer id;
            JobInfo ji;
            this.cleanStalePeers();
            this.updateNiceness();
            long availableMemory = this.maxManagedRss - this.getMaxPromisedMemory();
            this.checkPromises(availableMemory);
            long freeRSS = LinuxCommands.getInstance().getSystemRSSFreeMemory();
            if (availableMemory > freeRSS) {
                availableMemory = freeRSS;
            }
            JobSet.QueueIterator it = this.jobSet.getQueue();
            while (it.hasNext() && (ji = this.jobMap.get(id = (Integer)it.next())).getSubmitChannel().getRequest().getMaxRSS() <= availableMemory) {
                it.moveToRunning();
                this.execute(id, ji);
                availableMemory -= ji.getSubmitChannel().getRequest().getMaxRSS();
            }
            int position = 0;
            it = this.jobSet.getQueue();
            while (it.hasNext()) {
                Integer id2 = (Integer)it.next();
                JobInfo ji2 = this.jobMap.get(id2);
                if (++position == ji2.getPreviousQueuePosition()) continue;
                ji2.getSubmitChannel().sendEvent(Event.queued, position);
                ji2.setPreviousQueuePosition(position);
            }
            this.jobList = this.createJobList(false);
        }
    }

    private void updateNiceness() throws IOException, InterruptedException {
        this.updateNiceness(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNiceness(Integer pId) throws IOException, InterruptedException {
        JobSet jobSet = this.jobSet;
        synchronized (jobSet) {
            JobSet.RunningIterator running = this.jobSet.getRunning();
            int i = 0;
            while (running.hasNext()) {
                Integer id = (Integer)running.next();
                ProcessInfo pi = this.processMap.get(id);
                if (pi != null && (pId == null || pi.getPid() == pId.intValue())) {
                    pi.setNiceness(NicenessHandler.getInstance().getNiceness(i, this.jobSet.countRunning(), Config.getInstance().getProcessCfg().getNicenessRange()[0], Config.getInstance().getProcessCfg().getNicenessRange()[1]));
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long checkPromises(long availableMemory) throws IOException, InterruptedException {
        JobSet jobSet = this.jobSet;
        synchronized (jobSet) {
            long[] treeRSSs;
            long currentRSS = 0L;
            int[] pIds = this.getPIds();
            if (pIds.length > 0 && (treeRSSs = LinuxCommands.getInstance().getTreeRSS(pIds)) != null) {
                int i = 0;
                JobSet.RunningIterator running = this.jobSet.getRunning();
                while (running.hasNext()) {
                    Integer id = (Integer)running.next();
                    ProcessInfo pi = this.processMap.get(id);
                    long treeRSS = treeRSSs[i++];
                    currentRSS += treeRSS;
                    if (treeRSS == 0L) continue;
                    if (treeRSS > pi.getMaxSeenRSS()) {
                        pi.setMaxSeenRSS(treeRSS);
                    }
                    if (pi.getMaxRSS() >= treeRSS) continue;
                    boolean allowed = PromiseHandler.getInstance().promiseFailed(availableMemory, pi, treeRSS);
                    if (allowed) {
                        availableMemory = availableMemory + pi.getJobInfo().getSubmitChannel().getRequest().getMaxRSS() - treeRSS;
                        pi.setMaxRSS(treeRSS);
                        pi.setAllowed(true);
                        continue;
                    }
                    LinuxCommands.getInstance().killTree(pi.getPid());
                }
            }
            return currentRSS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(PeerChannel<SubmitInput> submitChannel) throws IOException, InterruptedException {
        JobInfo ji;
        if (this.closed) {
            throw new IllegalStateException("Instance is closed");
        }
        if (submitChannel == null) {
            throw new IllegalArgumentException("Request info is required");
        }
        if (Config.getInstance().getSchedulerCfg().getMaxJobRSSBytes() > 0 && submitChannel.getRequest().getMaxRSS() > (long)Config.getInstance().getSchedulerCfg().getMaxJobRSSBytes() || this.maxManagedRss < submitChannel.getRequest().getMaxRSS()) {
            submitChannel.sendEvent(Event.exceed_global, Config.getInstance().getSchedulerCfg().getMaxJobRSSBytes());
            submitChannel.sendEvent(Event.retcode, RetCode.ERROR.getCode());
            submitChannel.close();
            return;
        }
        long treeRSS = submitChannel.getRequest().getMaxRSS();
        Integer parentId = submitChannel.getRequest().getParentId();
        while (parentId != null && (ji = this.jobMap.get(parentId)) != null) {
            treeRSS += ji.getSubmitChannel().getRequest().getMaxRSS();
            parentId = ji.getSubmitChannel().getRequest().getParentId();
        }
        if (treeRSS > this.maxManagedRss) {
            submitChannel.sendEvent(Event.exceed_tree, treeRSS);
            submitChannel.sendEvent(Event.retcode, RetCode.ERROR.getCode());
            submitChannel.close();
            return;
        }
        if (submitChannel.getRequest().getGroupName() == null) {
            submitChannel.getRequest().setGroupName(DEFAULT_GROUP_NAME);
        }
        int id = this.jobCounter.incrementAndGet();
        JobSet jobSet = this.jobSet;
        synchronized (jobSet) {
            GroupInfo gi = this.groupMap.get(submitChannel.getRequest().getGroupName());
            if (gi == null) {
                gi = this.createGroupInfo(submitChannel.getRequest().getGroupName(), submitChannel.getUser(), 0, Config.getInstance().getGroupCfg().getDynamicGroupIdleSeconds());
            }
            gi.getJobs().add(id);
            JobInfo ji2 = new JobInfo(id, submitChannel);
            this.jobMap.put(id, ji2);
            submitChannel.sendEvent(Event.id, id);
            this.jobSet.queue(id, gi.getPriority(), gi.getGroupId());
            submitChannel.sendEvent(Event.priority, gi.getPriority());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createJobList(boolean noHeaders) {
        StringBuilder sb = new StringBuilder(200);
        try {
            if (!noHeaders) {
                sb.append(ANSICode.CLEAR.getCode());
                sb.append(ANSICode.MOVE_TO_TOP.getCode());
                sb.append(ANSICode.BLACK.getCode());
                sb.append(ANSICode.BG_GREEN.getCode());
                sb.append(StringUtils.leftPad((String)"ID", (int)8));
                sb.append(" ");
                sb.append(StringUtils.leftPad((String)"PID", (int)8));
                sb.append(" ");
                sb.append(StringUtils.rightPad((String)"GROUP", (int)8));
                sb.append(" ");
                sb.append(StringUtils.rightPad((String)"USER", (int)8));
                sb.append(" ");
                sb.append(StringUtils.leftPad((String)"PRIORITY", (int)8));
                sb.append(" ");
                sb.append(StringUtils.leftPad((String)"QUEUE", (int)5));
                sb.append(" ");
                sb.append(StringUtils.leftPad((String)"PID", (int)8));
                sb.append(" ");
                sb.append(StringUtils.leftPad((String)"NICE", (int)4));
                sb.append(" ");
                sb.append(StringUtils.leftPad((String)"PROM_RSS", (int)10));
                sb.append(" ");
                sb.append(StringUtils.leftPad((String)"SEEN_RSS", (int)10));
                sb.append(" ");
                sb.append("CMD");
                sb.append(ANSICode.END_OF_LINE.getCode());
                sb.append(ANSICode.RESET.getCode());
            } else {
                ANSICode.setActive(false);
            }
            JobSet jobSet = this.jobSet;
            synchronized (jobSet) {
                JobSet.RunningIterator runningIterator = this.jobSet.getRunning();
                while (runningIterator.hasNext()) {
                    String[] mem;
                    String pId;
                    Integer id = (Integer)runningIterator.next();
                    JobInfo ji = this.jobMap.get(id);
                    ProcessInfo pi = this.processMap.get(id);
                    GroupInfo gi = this.groupMap.get(ji.getSubmitChannel().getRequest().getGroupName());
                    sb.append("\n");
                    sb.append(ANSICode.NO_WRAP.getCode());
                    if (pi != null) {
                        sb.append(StringUtils.leftPad((String)String.valueOf(id), (int)8));
                        sb.append(" ");
                        pId = ji.getSubmitChannel().getRequest().getParentId() != null ? String.valueOf(ji.getSubmitChannel().getRequest().getParentId()) : "";
                        sb.append(StringUtils.leftPad((String)pId, (int)8));
                        sb.append(" ");
                        sb.append(StringUtils.rightPad((String)String.valueOf(gi.getGroupName()), (int)8));
                        sb.append(" ");
                        sb.append(StringUtils.rightPad((String)ji.getSubmitChannel().getUser(), (int)8));
                        sb.append(" ");
                        sb.append(StringUtils.leftPad((String)String.valueOf(gi.getPriority()), (int)8));
                        sb.append(" ");
                        sb.append(StringUtils.leftPad((String)"", (int)5));
                        sb.append(" ");
                        sb.append(StringUtils.leftPad((String)String.valueOf(pi.getPid()), (int)8));
                        sb.append(" ");
                        sb.append(StringUtils.leftPad((String)String.valueOf(pi.getNiceness()), (int)4));
                        sb.append(" ");
                        mem = Miscellaneous.humanReadableByteCount((long)ji.getSubmitChannel().getRequest().getMaxRSS(), (boolean)Config.getInstance().getuICfg().issIMemoryUnits()).split(" ");
                        sb.append(StringUtils.leftPad((String)mem[0], (int)6));
                        sb.append(" ");
                        sb.append(StringUtils.rightPad((String)mem[1], (int)3));
                        sb.append(" ");
                        if ((double)pi.getMaxSeenRSS() > 0.9 * (double)ji.getSubmitChannel().getRequest().getMaxRSS()) {
                            sb.append(ANSICode.RED.getCode());
                        }
                        mem = Miscellaneous.humanReadableByteCount((long)pi.getMaxSeenRSS(), (boolean)Config.getInstance().getuICfg().issIMemoryUnits()).split(" ");
                        sb.append(StringUtils.leftPad((String)mem[0], (int)6));
                        sb.append(" ");
                        sb.append(StringUtils.rightPad((String)mem[1], (int)3));
                        sb.append(ANSICode.RESET.getCode());
                        sb.append(" ");
                        sb.append(Arrays.toString(ji.getSubmitChannel().getRequest().getCommand()));
                        sb.append(" ");
                    } else {
                        sb.append(StringUtils.leftPad((String)String.valueOf(id), (int)8));
                        sb.append(" ");
                        pId = ji.getSubmitChannel().getRequest().getParentId() != null ? String.valueOf(ji.getSubmitChannel().getRequest().getParentId()) : "";
                        sb.append(StringUtils.leftPad((String)pId, (int)8));
                        sb.append(" ");
                        sb.append(StringUtils.rightPad((String)String.valueOf(gi.getGroupName()), (int)8));
                        sb.append(" ");
                        sb.append(StringUtils.rightPad((String)ji.getSubmitChannel().getUser(), (int)8));
                        sb.append(" ");
                        sb.append(StringUtils.leftPad((String)String.valueOf(gi.getPriority()), (int)8));
                        sb.append(" ");
                        sb.append(StringUtils.leftPad((String)"", (int)5));
                        sb.append(" ");
                        sb.append(StringUtils.leftPad((String)"", (int)8));
                        sb.append(" ");
                        sb.append(StringUtils.leftPad((String)"", (int)4));
                        sb.append(" ");
                        mem = Miscellaneous.humanReadableByteCount((long)ji.getSubmitChannel().getRequest().getMaxRSS(), (boolean)Config.getInstance().getuICfg().issIMemoryUnits()).split(" ");
                        sb.append(StringUtils.leftPad((String)mem[0], (int)6));
                        sb.append(" ");
                        sb.append(StringUtils.rightPad((String)mem[1], (int)3));
                        sb.append(" ");
                        sb.append(StringUtils.leftPad((String)"", (int)10));
                        sb.append(" ");
                        sb.append(Arrays.toString(ji.getSubmitChannel().getRequest().getCommand()));
                        sb.append(" ");
                    }
                    sb.append(ANSICode.WRAP.getCode());
                }
                int position = 0;
                JobSet.QueueIterator queueIterator = this.jobSet.getQueue();
                while (queueIterator.hasNext()) {
                    ++position;
                    Integer id = (Integer)queueIterator.next();
                    JobInfo ji = this.jobMap.get(id);
                    GroupInfo gi = this.groupMap.get(ji.getSubmitChannel().getRequest().getGroupName());
                    sb.append("\n");
                    sb.append(ANSICode.NO_WRAP.getCode());
                    sb.append(ANSICode.YELLOW.getCode());
                    sb.append(StringUtils.leftPad((String)String.valueOf(id), (int)8));
                    sb.append(" ");
                    String pId = ji.getSubmitChannel().getRequest().getParentId() != null ? String.valueOf(ji.getSubmitChannel().getRequest().getParentId()) : "";
                    sb.append(StringUtils.leftPad((String)pId, (int)8));
                    sb.append(" ");
                    sb.append(StringUtils.rightPad((String)String.valueOf(ji.getSubmitChannel().getRequest().getGroupName()), (int)8));
                    sb.append(" ");
                    sb.append(StringUtils.rightPad((String)ji.getSubmitChannel().getUser(), (int)8));
                    sb.append(" ");
                    sb.append(StringUtils.leftPad((String)String.valueOf(gi.getPriority()), (int)8));
                    sb.append(" ");
                    sb.append(StringUtils.leftPad((String)String.valueOf(position), (int)5));
                    sb.append(" ");
                    sb.append(StringUtils.leftPad((String)"", (int)8));
                    sb.append(" ");
                    sb.append(StringUtils.leftPad((String)"", (int)4));
                    sb.append(" ");
                    String[] mem = Miscellaneous.humanReadableByteCount((long)ji.getSubmitChannel().getRequest().getMaxRSS(), (boolean)Config.getInstance().getuICfg().issIMemoryUnits()).split(" ");
                    sb.append(StringUtils.leftPad((String)mem[0], (int)6));
                    sb.append(" ");
                    sb.append(StringUtils.rightPad((String)mem[1], (int)3));
                    sb.append(" ");
                    sb.append(StringUtils.leftPad((String)"", (int)10));
                    sb.append(" ");
                    sb.append(Arrays.toString(ji.getSubmitChannel().getRequest().getCommand()));
                    sb.append(" ");
                    sb.append(ANSICode.RESET.getCode());
                    sb.append(ANSICode.WRAP.getCode());
                }
            }
        }
        finally {
            ANSICode.setActive(true);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listGroups(PeerChannel<Void> channel, boolean noHeaders) throws IOException, InterruptedException {
        try {
            if (!noHeaders) {
                StringBuilder header = new StringBuilder(ANSICode.CLEAR.getCode());
                header.append(ANSICode.MOVE_TO_TOP.getCode());
                header.append(ANSICode.BLACK.getCode());
                header.append(ANSICode.BG_GREEN.getCode());
                header.append(StringUtils.rightPad((String)"GROUP", (int)8));
                header.append(" ");
                header.append(StringUtils.rightPad((String)"USER", (int)8));
                header.append(" ");
                header.append(StringUtils.leftPad((String)"PRIORITY", (int)8));
                header.append(" ");
                header.append(StringUtils.leftPad((String)"IDLE_TIME", (int)9));
                header.append(" ");
                header.append(StringUtils.leftPad((String)"JOBS", (int)5));
                header.append(ANSICode.END_OF_LINE.getCode());
                header.append(ANSICode.RESET.getCode());
                PeerChannel.println(channel.getStdoutOs(), header.toString());
            } else {
                ANSICode.setActive(false);
            }
            JobSet jobSet = this.jobSet;
            synchronized (jobSet) {
                TreeSet<GroupInfo> groups = new TreeSet<GroupInfo>(this.groupMap.values());
                for (GroupInfo gi : groups) {
                    StringBuilder line = new StringBuilder();
                    line.append(StringUtils.rightPad((String)String.valueOf(gi.getGroupName()), (int)8));
                    line.append(" ");
                    line.append(StringUtils.rightPad((String)gi.getUser(), (int)8));
                    line.append(" ");
                    line.append(StringUtils.leftPad((String)String.valueOf(gi.getPriority()), (int)8));
                    line.append(" ");
                    line.append(StringUtils.leftPad((String)String.valueOf(gi.getTimeToIdelSeconds()), (int)9));
                    line.append(" ");
                    line.append(StringUtils.leftPad((String)String.valueOf(gi.getJobs().size()), (int)5));
                    PeerChannel.println(channel.getStdoutOs(), line.toString());
                }
            }
        }
        finally {
            ANSICode.setActive(true);
            channel.sendEvent(Event.retcode, 0);
            channel.close();
        }
    }

    public void listJobs(PeerChannel<Void> channel, boolean noHeaders) throws IOException, InterruptedException {
        try {
            if (noHeaders) {
                PeerChannel.println(channel.getStdoutOs(), this.createJobList(true));
            } else {
                PeerChannel.println(channel.getStdoutOs(), this.jobList);
            }
        }
        finally {
            channel.sendEvent(Event.retcode, 0);
            channel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void cancel(PeerChannel<CancelInput> cancelChannel) throws IOException, InterruptedException {
        JobSet.State state;
        int id;
        block11: {
            JobInfo ji;
            block12: {
                if (this.closed) {
                    throw new IllegalStateException("Instance is closed");
                }
                id = cancelChannel.getRequest().getId();
                JobSet jobSet = this.jobSet;
                // MONITORENTER : jobSet
                state = this.jobSet.getState(id);
                if (state == null) {
                    cancelChannel.log(ANSICode.RED, "job not found");
                    cancelChannel.sendEvent(Event.retcode, RetCode.ERROR.getCode());
                    return;
                }
                if (state != JobSet.State.queued) break block11;
                ji = this.jobMap.get(id);
                if (ji == null) throw new AssertionError();
                if (cancelChannel.getUser().equals("root") || cancelChannel.getUser().equals(ji.getSubmitChannel().getUser())) break block12;
                cancelChannel.log(ANSICode.RED, "user '" + cancelChannel.getUser() + "' is not allowed to cancel a job from user '" + ji.getSubmitChannel().getUser() + "'");
                cancelChannel.sendEvent(Event.retcode, RetCode.ERROR.getCode());
                // MONITOREXIT : jobSet
                cancelChannel.close();
                return;
            }
            ji.getSubmitChannel().sendEvent(Event.cancelled, cancelChannel.getUser());
            ji.getSubmitChannel().sendEvent(Event.retcode, RetCode.ERROR.getCode());
            ji.getSubmitChannel().close();
            cancelChannel.log(ANSICode.GREEN, "enqueued job sucessfully cancelled");
            cancelChannel.sendEvent(Event.retcode, 0);
            GroupInfo gi = this.groupMap.get(ji.getSubmitChannel().getRequest().getGroupName());
            gi.getJobs().remove(id);
            this.jobSet.remove(id);
            this.jobMap.remove(id);
            return;
        }
        if (state != JobSet.State.running) return;
        ProcessInfo pi = this.processMap.get(id);
        if (pi == null) return;
        if (!cancelChannel.getUser().equals("root") && !cancelChannel.getUser().equals(pi.getJobInfo().getSubmitChannel().getUser())) {
            cancelChannel.log(ANSICode.RED, "user '" + cancelChannel.getUser() + "' is not allowed to cancel a job from user '" + pi.getJobInfo().getSubmitChannel().getUser() + "'");
            cancelChannel.sendEvent(Event.retcode, RetCode.ERROR.getCode());
            // MONITOREXIT : jobSet
            cancelChannel.close();
            return;
        }
        try {
            pi.getJobInfo().getSubmitChannel().sendEvent(Event.cancelled, cancelChannel.getUser());
            LinuxCommands.getInstance().killTree(pi.getPid());
            cancelChannel.log(ANSICode.GREEN, "running job sucessfully cancelled");
            cancelChannel.sendEvent(Event.retcode, 0);
            // MONITOREXIT : jobSet
            return;
        }
        finally {
            cancelChannel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void updateGroup(PeerChannel<GroupInput> channel) throws IOException {
        GroupInfo gi;
        block21: {
            if (this.closed) {
                throw new IllegalStateException("Instance is closed");
            }
            JobSet jobSet = this.jobSet;
            // MONITORENTER : jobSet
            gi = this.groupMap.get(channel.getRequest().getGroupName());
            if (gi != null) break block21;
            this.createGroupInfo(channel.getRequest().getGroupName(), channel.getUser(), channel.getRequest().getPriority(), channel.getRequest().getTimetoIdleSeconds());
            channel.log(ANSICode.GREEN, "Group '" + channel.getRequest().getGroupName() + "' created successfully");
            channel.sendEvent(Event.retcode, 0);
            // MONITOREXIT : jobSet
            channel.close();
            return;
        }
        if (channel.getRequest().isDelete()) {
            if (!channel.getUser().equals("root") && !channel.getUser().equals(gi.getUser())) {
                if (gi.getUser().equals("root")) {
                    channel.log(ANSICode.RED, "Group '" + channel.getRequest().getGroupName() + "' can only be updated by user 'root'");
                } else {
                    channel.log(ANSICode.RED, "Group '" + channel.getRequest().getGroupName() + "' can only be updated by users 'root' and '" + gi.getUser() + "'");
                }
                channel.sendEvent(Event.retcode, RetCode.ERROR.getCode());
                // MONITOREXIT : jobSet
                channel.close();
                return;
            }
            if (gi.getJobs().isEmpty()) {
                channel.log(ANSICode.GREEN, "Group '" + channel.getRequest().getGroupName() + "' deleted successfully");
                this.groupMap.remove(channel.getRequest().getGroupName());
                channel.sendEvent(Event.retcode, 0);
                // MONITOREXIT : jobSet
                channel.close();
                return;
            }
            channel.log(ANSICode.RED, "Group '" + channel.getRequest().getGroupName() + "' cannot be deleted, since it contains " + gi.getJobs().size() + " active jobs");
            channel.sendEvent(Event.retcode, RetCode.ERROR.getCode());
            // MONITOREXIT : jobSet
            channel.close();
            return;
        }
        try {
            int newTimetoIdleSeconds;
            int newPriority = channel.getRequest().getPriority();
            if (newPriority != gi.getPriority()) {
                Set<Integer> set = gi.getJobs();
                // MONITORENTER : set
                for (Integer id : gi.getJobs()) {
                    this.jobSet.setPriority(id, newPriority, gi.getGroupId());
                    JobInfo ji = this.jobMap.get(id);
                    ji.getSubmitChannel().sendEvent(Event.priority, newPriority);
                }
                // MONITOREXIT : set
                gi.setPriority(newPriority);
                channel.log(ANSICode.GREEN, "Group '" + channel.getRequest().getGroupName() + "' priority updated successfully");
            }
            if ((newTimetoIdleSeconds = channel.getRequest().getTimetoIdleSeconds()) != gi.getTimeToIdelSeconds()) {
                gi.setTimeToIdelSeconds(newTimetoIdleSeconds);
                channel.log(ANSICode.GREEN, "Group '" + channel.getRequest().getGroupName() + "' time-to-idle updated successfully");
            }
            channel.sendEvent(Event.retcode, 0);
            // MONITOREXIT : jobSet
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            channel.close();
        }
    }

    private void execute(final int id, final JobInfo ji) {
        if (ji == null) {
            throw new IllegalArgumentException("Id is required");
        }
        Thread t = new Thread(this.threadGroup, "scheduled process " + id){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProcessInfo pi;
                int pId;
                Process process;
                String[] cmd = ji.getSubmitChannel().getRequest().getCommand();
                if (Scheduler.this.runningUser.equals("root")) {
                    cmd = LinuxCommands.getInstance().getRunAsCommand(ji.getSubmitChannel().getUser(), cmd);
                }
                cmd = LinuxCommands.getInstance().decorateWithCPUAffinity(cmd, Config.getInstance().getProcessCfg().getCpuAfinity());
                ProcessBuilder pb = new ProcessBuilder(cmd);
                pb.environment().clear();
                pb.directory(ji.getSubmitChannel().getRequest().getWorkingDirectory());
                if (ji.getSubmitChannel().getRequest().getEnvironment() != null) {
                    pb.environment().putAll(ji.getSubmitChannel().getRequest().getEnvironment());
                }
                pb.environment().put("WAVA_JOB_ID", String.valueOf(id));
                try {
                    try {
                        process = pb.start();
                        pId = Miscellaneous.getUnixId((Process)process);
                        ji.getSubmitChannel().sendEvent(Event.running, pId);
                        pi = new ProcessInfo(ji, pId);
                        JobSet jobSet = Scheduler.this.jobSet;
                        synchronized (jobSet) {
                            Scheduler.this.processMap.put(ji.getId(), pi);
                        }
                        Scheduler.this.updateNiceness(pId);
                    }
                    catch (Exception ex) {
                        ji.getSubmitChannel().sendEvent(Event.error, JsonCodec.getInstance().transform((Object)Miscellaneous.getStrackTrace((Throwable)ex)));
                        ji.getSubmitChannel().sendEvent(Event.retcode, RetCode.ERROR.getCode());
                        try {
                            ji.getSubmitChannel().close();
                            JobSet jobSet = Scheduler.this.jobSet;
                            synchronized (jobSet) {
                                Scheduler.this.jobSet.remove(id);
                                Scheduler.this.jobMap.remove(id);
                                Scheduler.this.processMap.remove(id);
                                GroupInfo gi = (GroupInfo)Scheduler.this.groupMap.get(ji.getSubmitChannel().getRequest().getGroupName());
                                gi.getJobs().remove(id);
                                if (gi.getJobs().isEmpty()) {
                                    if (gi.getTimeToIdelSeconds() == 0) {
                                        Scheduler.this.groupMap.remove(gi.getGroupName());
                                    } else if (gi.getTimeToIdelSeconds() > 0) {
                                        Thread t = new Thread(Scheduler.this.threadGroup, "group-" + gi.getGroupName() + " idle thread", gi){
                                            final /* synthetic */ GroupInfo val$gi;
                                            {
                                                this.val$gi = groupInfo;
                                                super(x0, x1);
                                            }

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            @Override
                                            public void run() {
                                                try {
                                                    Thread.sleep(1000 * this.val$gi.getTimeToIdelSeconds());
                                                    JobSet jobSet = Scheduler.this.jobSet;
                                                    synchronized (jobSet) {
                                                        if (this.val$gi.getJobs().isEmpty()) {
                                                            Scheduler.this.groupMap.remove(this.val$gi.getGroupName());
                                                        }
                                                    }
                                                }
                                                catch (InterruptedException ex) {
                                                    Logger.getLogger(Scheduler.class.getName()).log(Level.SEVERE, null, ex);
                                                }
                                            }
                                        };
                                        t.setDaemon(true);
                                        t.start();
                                    }
                                }
                            }
                        }
                        catch (Throwable th) {
                            LOGGER.log(Level.SEVERE, th.getMessage(), th);
                        }
                        return;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        ji.getSubmitChannel().close();
                        JobSet jobSet = Scheduler.this.jobSet;
                        synchronized (jobSet) {
                            Scheduler.this.jobSet.remove(id);
                            Scheduler.this.jobMap.remove(id);
                            Scheduler.this.processMap.remove(id);
                            GroupInfo gi = (GroupInfo)Scheduler.this.groupMap.get(ji.getSubmitChannel().getRequest().getGroupName());
                            gi.getJobs().remove(id);
                            if (gi.getJobs().isEmpty()) {
                                if (gi.getTimeToIdelSeconds() == 0) {
                                    Scheduler.this.groupMap.remove(gi.getGroupName());
                                } else if (gi.getTimeToIdelSeconds() > 0) {
                                    Thread t = new /* invalid duplicate definition of identical inner class */;
                                    t.setDaemon(true);
                                    t.start();
                                }
                            }
                        }
                    }
                    catch (Throwable th) {
                        LOGGER.log(Level.SEVERE, th.getMessage(), th);
                    }
                    throw throwable;
                }
                Object stoutReaderThread = Miscellaneous.pipeAsynchronously((InputStream)process.getInputStream(), (ErrorHandler)null, (boolean)true, (OutputStream[])new OutputStream[]{ji.getSubmitChannel().getStdoutOs()});
                ((Thread)stoutReaderThread).setName("stdout-pid-" + pId);
                Thread sterrReaderThread = Miscellaneous.pipeAsynchronously((InputStream)process.getErrorStream(), (ErrorHandler)null, (boolean)true, (OutputStream[])new OutputStream[]{ji.getSubmitChannel().getStderrOs()});
                sterrReaderThread.setName("stderr-pid-" + pId);
                try {
                    int code = process.waitFor();
                    ji.getSubmitChannel().sendEvent(Event.maxrss, pi.getMaxSeenRSS());
                    ji.getSubmitChannel().sendEvent(Event.retcode, code);
                }
                catch (InterruptedException ex) {
                    try {
                        LinuxCommands.getInstance().killTree(pId);
                    }
                    catch (Throwable th) {
                        LOGGER.log(Level.SEVERE, th.getMessage());
                    }
                }
                finally {
                    try {
                        ((Thread)stoutReaderThread).join();
                        sterrReaderThread.join();
                    }
                    catch (Throwable th) {
                        LOGGER.log(Level.SEVERE, th.getMessage());
                    }
                }
                try {
                    ji.getSubmitChannel().close();
                    stoutReaderThread = Scheduler.this.jobSet;
                    synchronized (stoutReaderThread) {
                        Scheduler.this.jobSet.remove(id);
                        Scheduler.this.jobMap.remove(id);
                        Scheduler.this.processMap.remove(id);
                        GroupInfo gi = (GroupInfo)Scheduler.this.groupMap.get(ji.getSubmitChannel().getRequest().getGroupName());
                        gi.getJobs().remove(id);
                        if (gi.getJobs().isEmpty()) {
                            if (gi.getTimeToIdelSeconds() == 0) {
                                Scheduler.this.groupMap.remove(gi.getGroupName());
                            } else if (gi.getTimeToIdelSeconds() > 0) {
                                Thread t = new /* invalid duplicate definition of identical inner class */;
                                t.setDaemon(true);
                                t.start();
                            }
                        }
                    }
                }
                catch (Throwable th) {
                    LOGGER.log(Level.SEVERE, th.getMessage(), th);
                }
            }
        };
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        JobSet jobSet = this.jobSet;
        synchronized (jobSet) {
            this.closed = true;
            this.threadGroup.interrupt();
        }
    }

    public class ProcessInfo {
        private final JobInfo jobInfo;
        private final int pId;
        private long maxRSS;
        private long maxSeenRSS;
        private int niceness = Integer.MAX_VALUE;
        private boolean allowed;

        public ProcessInfo(JobInfo jobInfo, int pId) {
            this.jobInfo = jobInfo;
            this.pId = pId;
            this.maxRSS = jobInfo.getSubmitChannel().getRequest().getMaxRSS();
        }

        public int getPid() {
            return this.pId;
        }

        public long getMaxSeenRSS() {
            return this.maxSeenRSS;
        }

        public void setMaxSeenRSS(long maxSeenRSS) {
            this.maxSeenRSS = maxSeenRSS;
        }

        public int getNiceness() {
            return this.niceness;
        }

        public JobInfo getJobInfo() {
            return this.jobInfo;
        }

        public int getpId() {
            return this.pId;
        }

        public long getMaxRSS() {
            return this.maxRSS;
        }

        public void setMaxRSS(long maxRSS) {
            this.maxRSS = maxRSS;
        }

        public boolean isAllowed() {
            return this.allowed;
        }

        public void setAllowed(boolean allowed) {
            this.allowed = allowed;
        }

        public void setNiceness(int niceness) throws IOException, InterruptedException {
            if (niceness != this.niceness) {
                LinuxCommands.getInstance().setNiceness(this.pId, niceness);
                this.jobInfo.getSubmitChannel().sendEvent(Event.niceness, niceness);
                this.niceness = niceness;
            }
        }
    }

    public class JobInfo {
        private final int id;
        private final PeerChannel<SubmitInput> submitChannel;
        private int previousQueuePosition;

        public JobInfo(int id, PeerChannel<SubmitInput> submitChannel) throws IOException, InterruptedException {
            this.id = id;
            this.submitChannel = submitChannel;
        }

        public int getPreviousQueuePosition() {
            return this.previousQueuePosition;
        }

        public void setPreviousQueuePosition(int previousQueuePosition) {
            this.previousQueuePosition = previousQueuePosition;
        }

        public int getId() {
            return this.id;
        }

        public PeerChannel<SubmitInput> getSubmitChannel() {
            return this.submitChannel;
        }
    }

    public class GroupInfo
    implements Comparable<GroupInfo> {
        private final String groupName;
        private final int groupId;
        private final String user;
        private final Set<Integer> jobs = Collections.synchronizedNavigableSet(new TreeSet());
        private int timeToIdelSeconds;
        private int priority;

        public GroupInfo(String groupName, String user, int timeToIdelSeconds) {
            this.groupName = groupName;
            this.groupId = Scheduler.this.groupCounter.incrementAndGet();
            this.user = user;
            this.timeToIdelSeconds = timeToIdelSeconds;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public int getGroupId() {
            return this.groupId;
        }

        public String getUser() {
            return this.user;
        }

        public Set<Integer> getJobs() {
            return this.jobs;
        }

        public void setTimeToIdelSeconds(int timeToIdelSeconds) {
            this.timeToIdelSeconds = timeToIdelSeconds;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public int getTimeToIdelSeconds() {
            return this.timeToIdelSeconds;
        }

        @Override
        public int compareTo(GroupInfo o) {
            if (o == null) {
                return 1;
            }
            int ret = Integer.compare(this.priority, o.getPriority());
            if (ret == 0) {
                ret = Integer.compare(this.groupId, o.getGroupId());
            }
            return ret;
        }
    }
}

