/*
 * Decompiled with CFR 0.152.
 */
package org.brutusin.wava.core.cfg;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.brutusin.commons.utils.Miscellaneous;
import org.brutusin.json.spi.JsonCodec;
import org.brutusin.wava.core.Environment;
import org.brutusin.wava.core.cfg.GroupCfg;
import org.brutusin.wava.core.cfg.ProcessCfg;
import org.brutusin.wava.core.cfg.SchedulerCfg;
import org.brutusin.wava.core.cfg.UICfg;
import org.brutusin.wava.core.cfg.impl.ConfigImpl;

public class Config {
    private static final Config INSTANCE = new Config();
    private final ConfigImpl impl;

    private Config() {
        try {
            File cfgFile = new File(Environment.ROOT, "cfg/wava.json");
            if (!cfgFile.exists()) {
                throw new Error("Config file not found " + cfgFile.getAbsolutePath());
            }
            String str = Miscellaneous.toString((InputStream)new FileInputStream(cfgFile), (String)"UTF-8");
            this.impl = (ConfigImpl)JsonCodec.getInstance().parse(Config.replaceEnvEntries(str), ConfigImpl.class);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    private static String replaceEnvEntries(String str) {
        StringBuilder sb = new StringBuilder(str);
        for (String envEntry : System.getenv().keySet()) {
            String entryName = "$" + envEntry;
            int i = sb.indexOf(entryName);
            if (i < 0) continue;
            sb.replace(i, i + entryName.length(), System.getenv().get(envEntry));
        }
        return sb.toString();
    }

    public static Config getInstance() {
        return INSTANCE;
    }

    public SchedulerCfg getSchedulerCfg() {
        return this.impl.getSchedulerCfg();
    }

    public ProcessCfg getProcessCfg() {
        return this.impl.getProcessCfg();
    }

    public GroupCfg getGroupCfg() {
        return this.impl.getGroupCfg();
    }

    public UICfg getuICfg() {
        return this.impl.getuICfg();
    }
}

