/*
 * Decompiled with CFR 0.152.
 */
package org.brutusin.wava.core.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.brutusin.commons.Bean;
import org.brutusin.commons.utils.Miscellaneous;
import org.brutusin.wava.core.io.Event;
import org.brutusin.wava.core.io.OrphanChannelException;
import org.brutusin.wava.utils.ANSICode;
import org.brutusin.wava.utils.Utils;

public class PeerChannel<T> {
    private static Logger LOGGER = Logger.getLogger(PeerChannel.class.getName());
    private final String user;
    private final T request;
    private boolean closed = false;
    private final FileOutputStream eventsOs;
    private final FileOutputStream stdoutOs;
    private final FileOutputStream stderrOs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerChannel(String user, T input, File namedPipesRoot) throws OrphanChannelException, IOException {
        this.user = user;
        this.request = input;
        final File eventsNamedPipe = new File(namedPipesRoot, NamedPipe.events.name());
        final File stdoutNamedPipe = new File(namedPipesRoot, NamedPipe.stdout.name());
        final File stderrNamedPipe = new File(namedPipesRoot, NamedPipe.stderr.name());
        final Bean initializedBean = new Bean();
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Thread.sleep(5000L);
                    Bean bean = initializedBean;
                    synchronized (bean) {
                        if (initializedBean.getValue() == null) {
                            initializedBean.setValue((Object)false);
                            try {
                                new FileInputStream(eventsNamedPipe).close();
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            try {
                                new FileInputStream(stdoutNamedPipe).close();
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            try {
                                new FileInputStream(stderrNamedPipe).close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
        };
        t.setDaemon(true);
        t.start();
        this.eventsOs = new FileOutputStream(eventsNamedPipe);
        this.stdoutOs = new FileOutputStream(stdoutNamedPipe);
        this.stderrOs = new FileOutputStream(stderrNamedPipe);
        Bean bean = initializedBean;
        synchronized (bean) {
            if (initializedBean.getValue() != null) {
                throw new OrphanChannelException();
            }
            initializedBean.setValue((Object)true);
        }
        Miscellaneous.deleteDirectory((File)namedPipesRoot);
    }

    public static boolean println(OutputStream os, String message) {
        try {
            os.write(message.getBytes());
            os.write("\n".getBytes());
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public String getUser() {
        return this.user;
    }

    public OutputStream getEventsOs() {
        return this.eventsOs;
    }

    public OutputStream getStdoutOs() {
        return this.stdoutOs;
    }

    public OutputStream getStderrOs() {
        return this.stderrOs;
    }

    public synchronized boolean log(ANSICode color, String message) {
        if (this.closed) {
            return false;
        }
        return PeerChannel.println(this.stderrOs, (Object)((Object)color) + "[wava] [" + Utils.DATE_FORMAT.format(new Date()) + "] " + message + (Object)((Object)ANSICode.RESET));
    }

    public boolean ping() {
        return this.sendEvent(Event.ping, null);
    }

    public synchronized boolean sendEvent(Event event, Object value) {
        if (this.closed) {
            return false;
        }
        if (value == null) {
            return PeerChannel.println(this.eventsOs, System.currentTimeMillis() + ":" + event.name());
        }
        return PeerChannel.println(this.eventsOs, System.currentTimeMillis() + ":" + event.name() + ":" + value);
    }

    public T getRequest() {
        return this.request;
    }

    public synchronized void close() throws IOException {
        this.closed = true;
        this.eventsOs.close();
        this.stdoutOs.close();
        this.stderrOs.close();
    }

    public static enum NamedPipe {
        events,
        stdout,
        stderr;

    }
}

