/*
 * Decompiled with CFR 0.152.
 */
package org.brutusin.wava.core.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Date;
import java.util.List;
import org.brutusin.commons.Bean;
import org.brutusin.commons.utils.Miscellaneous;
import org.brutusin.json.spi.JsonCodec;
import org.brutusin.json.spi.JsonNode;
import org.brutusin.wava.core.Environment;
import org.brutusin.wava.core.io.Event;
import org.brutusin.wava.core.io.OpName;
import org.brutusin.wava.core.io.PeerChannel;
import org.brutusin.wava.core.plug.LinuxCommands;
import org.brutusin.wava.utils.ANSICode;
import org.brutusin.wava.utils.Utils;

public class RequestExecutor {
    public static Integer executeRequest(OpName opName, Object input, final OutputStream eventStream, final boolean prettyEvents) throws IOException, InterruptedException {
        File counterFile = new File(Environment.TEMP, "state/.seq");
        long id = Miscellaneous.getGlobalAutoIncremental((File)counterFile);
        String json = JsonCodec.getInstance().transform(input);
        File streamRoot = new File(Environment.TEMP, "streams/" + id);
        Miscellaneous.createDirectory((File)streamRoot);
        final File eventsNamedPipe = new File(streamRoot, PeerChannel.NamedPipe.events.name());
        final File stdoutNamedPipe = new File(streamRoot, PeerChannel.NamedPipe.stdout.name());
        final File stderrNamedPipe = new File(streamRoot, PeerChannel.NamedPipe.stderr.name());
        LinuxCommands.getInstance().createNamedPipes(eventsNamedPipe, stderrNamedPipe, stdoutNamedPipe);
        final Bean retCode = new Bean();
        Thread eventsThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    String line;
                    FileInputStream eventsIs = new FileInputStream(eventsNamedPipe);
                    BufferedReader br = new BufferedReader(new InputStreamReader(eventsIs));
                    while ((line = br.readLine()) != null) {
                        List<String> tokens = Utils.parseEventLine(line);
                        Event evt = Event.valueOf(tokens.get(1));
                        String value = tokens.size() > 2 ? tokens.get(2) : null;
                        if (evt == Event.ping) continue;
                        if (evt == Event.retcode) {
                            retCode.setValue((Object)Integer.valueOf(value));
                        }
                        if (eventStream == null) continue;
                        if (!prettyEvents) {
                            OutputStream outputStream = eventStream;
                            synchronized (outputStream) {
                                eventStream.write((line + "\n").getBytes());
                                continue;
                            }
                        }
                        Date date = new Date(Long.valueOf(tokens.get(0)));
                        ANSICode color = ANSICode.CYAN;
                        if (evt == Event.id || evt == Event.running) {
                            color = ANSICode.GREEN;
                        } else if (evt == Event.queued) {
                            color = ANSICode.YELLOW;
                        } else if (evt == Event.cancelled) {
                            color = ANSICode.YELLOW;
                        } else if (evt == Event.retcode) {
                            color = (Integer)retCode.getValue() == 0 ? ANSICode.GREEN : ANSICode.RED;
                        } else if (evt == Event.exceed_allowed) {
                            color = ANSICode.YELLOW;
                        } else if (evt == Event.exceed_disallowed) {
                            color = ANSICode.RED;
                        } else if (evt == Event.exceed_global) {
                            color = ANSICode.YELLOW;
                        } else if (evt == Event.error) {
                            color = ANSICode.RED;
                            if (value != null) {
                                JsonNode node = JsonCodec.getInstance().parse(value);
                                value = node.asString();
                            }
                        }
                        OutputStream outputStream = eventStream;
                        synchronized (outputStream) {
                            eventStream.write((color.getCode() + "[wava] [" + Utils.DATE_FORMAT.format(date) + "] [" + (Object)((Object)evt) + (value != null ? ":" + value : "") + "]" + ANSICode.RESET.getCode() + "\n").getBytes());
                        }
                    }
                    return;
                }
                catch (Throwable th) {
                    th.printStackTrace(System.err);
                }
            }
        };
        Thread outThread = new Thread(){

            @Override
            public void run() {
                try {
                    FileInputStream outIs = new FileInputStream(stdoutNamedPipe);
                    Miscellaneous.pipeAsynchronously((InputStream)outIs, (OutputStream[])new OutputStream[]{System.out});
                }
                catch (Throwable th) {
                    th.printStackTrace(System.err);
                }
            }
        };
        Thread errThread = new Thread(){

            @Override
            public void run() {
                FileInputStream errIs = null;
                try {
                    errIs = new FileInputStream(stderrNamedPipe);
                    BufferedReader br = new BufferedReader(new InputStreamReader(errIs));
                    Miscellaneous.pipeSynchronously((BufferedReader)br, (boolean)false, (OutputStream[])new OutputStream[]{System.err});
                }
                catch (Throwable th) {
                    th.printStackTrace(System.err);
                }
                finally {
                    if (errIs != null) {
                        try {
                            ((InputStream)errIs).close();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace(System.err);
                        }
                    }
                }
            }
        };
        eventsThread.start();
        outThread.start();
        errThread.start();
        File tempFile = new File(Environment.TEMP, "temp/" + id + "-" + (Object)((Object)opName));
        File requestFile = new File(Environment.TEMP, "request/" + id + "-" + (Object)((Object)opName));
        Files.write(tempFile.toPath(), json.getBytes(), new OpenOption[0]);
        Files.move(tempFile.toPath(), requestFile.toPath(), new CopyOption[0]);
        eventsThread.join();
        outThread.join();
        errThread.join();
        return (Integer)retCode.getValue();
    }
}

