/*
 * Decompiled with CFR 0.152.
 */
package org.brutusin.wava.core.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.brutusin.commons.utils.Miscellaneous;
import org.brutusin.json.ParseException;
import org.brutusin.json.spi.JsonCodec;
import org.brutusin.wava.core.Environment;
import org.brutusin.wava.core.Scheduler;
import org.brutusin.wava.core.io.Event;
import org.brutusin.wava.core.io.OpName;
import org.brutusin.wava.core.io.OrphanChannelException;
import org.brutusin.wava.core.io.PeerChannel;
import org.brutusin.wava.core.plug.LinuxCommands;
import org.brutusin.wava.input.CancelInput;
import org.brutusin.wava.input.GroupInput;
import org.brutusin.wava.input.SubmitInput;
import org.brutusin.wava.utils.ANSICode;
import org.brutusin.wava.utils.RetCode;

public class RequestHandler {
    private static final Logger LOGGER = Logger.getLogger(RequestHandler.class.getName());
    public static final Pattern OP_FILE_PATTERN;
    private final Scheduler scheduler;
    private final File requestFolder;
    private final File streamsFolder;

    public RequestHandler(Scheduler scheduler) throws IOException {
        this.scheduler = scheduler;
        this.requestFolder = new File(Environment.TEMP, "request");
        this.streamsFolder = new File(Environment.TEMP, "streams");
        RequestHandler.remakeFolder(this.requestFolder);
        RequestHandler.remakeFolder(this.streamsFolder);
        RequestHandler.remakeFolder(new File(Environment.TEMP, "temp"));
        RequestHandler.remakeFolder(new File(Environment.TEMP, "state"));
    }

    private static void remakeFolder(File f) throws IOException {
        Miscellaneous.deleteDirectory((File)f);
        Miscellaneous.createDirectory((File)f);
    }

    public void start() throws IOException {
        WatchService watcher = FileSystems.getDefault().newWatchService();
        Path dir = Paths.get(this.requestFolder.getAbsolutePath(), new String[0]);
        dir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
        block3: while (true) {
            try {
                while (!Thread.interrupted()) {
                    WatchKey key = watcher.take();
                    for (WatchEvent<?> watchEvent : key.pollEvents()) {
                        if (Thread.interrupted()) break block3;
                        WatchEvent.Kind<?> kind = watchEvent.kind();
                        if (kind == StandardWatchEventKinds.OVERFLOW) {
                            LOGGER.log(Level.SEVERE, null, "Overflow event retrieved from watch service");
                            continue;
                        }
                        final File file = dir.resolve((Path)watchEvent.context()).toFile();
                        Thread t = new Thread(){

                            @Override
                            public void run() {
                                try {
                                    RequestHandler.this.handleRequest(file);
                                }
                                catch (Throwable th) {
                                    Logger.getLogger(RequestHandler.class.getName()).log(Level.SEVERE, null, th);
                                }
                            }
                        };
                        t.start();
                    }
                    if (key.reset()) continue;
                    LOGGER.log(Level.SEVERE, null, "Request directory is inaccessible");
                    break block3;
                }
            }
            catch (InterruptedException ie) {
            }
            catch (Throwable th) {
                LOGGER.log(Level.SEVERE, th.getMessage(), th);
                continue;
            }
            break;
        }
        watcher.close();
    }

    private void handleRequest(File requestFile) throws IOException, InterruptedException, ParseException {
        block17: {
            Matcher matcher = OP_FILE_PATTERN.matcher(requestFile.getName());
            if (matcher.matches()) {
                Integer id = Integer.valueOf(matcher.group(1));
                OpName opName = OpName.valueOf(matcher.group(2));
                String user = LinuxCommands.getInstance().getFileOwner(requestFile);
                String json = new String(Files.readAllBytes(requestFile.toPath()));
                PeerChannel<Object> ch = null;
                try {
                    if (opName == OpName.submit) {
                        SubmitInput input = (SubmitInput)JsonCodec.getInstance().parse(json, SubmitInput.class);
                        PeerChannel<SubmitInput> channel = new PeerChannel<SubmitInput>(user, input, new File(this.streamsFolder, String.valueOf(id)));
                        ch = channel;
                        this.scheduler.submit(channel);
                    } else if (opName == OpName.cancel) {
                        CancelInput input = (CancelInput)JsonCodec.getInstance().parse(json, CancelInput.class);
                        PeerChannel<CancelInput> channel = new PeerChannel<CancelInput>(user, input, new File(this.streamsFolder, String.valueOf(id)));
                        ch = channel;
                        this.scheduler.cancel(channel);
                    } else if (opName == OpName.jobs) {
                        Boolean noHeaders = (Boolean)JsonCodec.getInstance().parse(json, Boolean.class);
                        PeerChannel<Object> channel = new PeerChannel<Object>(user, null, new File(this.streamsFolder, String.valueOf(id)));
                        ch = channel;
                        this.scheduler.listJobs(channel, noHeaders);
                    } else if (opName == OpName.group) {
                        GroupInput input = (GroupInput)JsonCodec.getInstance().parse(json, GroupInput.class);
                        if (input.isList()) {
                            PeerChannel<Object> channel = new PeerChannel<Object>(user, null, new File(this.streamsFolder, String.valueOf(id)));
                            ch = channel;
                            this.scheduler.listGroups(channel, input.isNoHeaders());
                        } else {
                            PeerChannel<GroupInput> channel = new PeerChannel<GroupInput>(user, input, new File(this.streamsFolder, String.valueOf(id)));
                            ch = channel;
                            this.scheduler.updateGroup(channel);
                        }
                    }
                }
                catch (Throwable th) {
                    if (th instanceof IllegalArgumentException) {
                        PeerChannel.println(ch.getStderrOs(), (Object)((Object)ANSICode.RED) + "[wava] " + th.getMessage());
                        ch.sendEvent(Event.retcode, RetCode.ERROR.getCode());
                    } else {
                        if (th instanceof InterruptedException) {
                            throw (InterruptedException)th;
                        }
                        if (th instanceof OrphanChannelException) {
                            LOGGER.log(Level.WARNING, "Error processing request " + id + ": Orphan channel found");
                        } else {
                            LOGGER.log(Level.SEVERE, "Error processing request " + id + ": " + th.getMessage() + "\noperation:" + (Object)((Object)opName) + "\nuser:" + user + "\njson:" + json, th);
                            PeerChannel.println(ch.getStderrOs(), (Object)((Object)ANSICode.RED) + "[wava] An error has ocurred processing request " + id + ". See core process logs for more details");
                            ch.sendEvent(Event.retcode, RetCode.ERROR.getCode());
                        }
                    }
                    if (ch == null) break block17;
                    ch.close();
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println(JsonCodec.getInstance().parse("", SubmitInput.class));
    }

    static {
        StringBuilder sb = new StringBuilder("(\\d+)-(");
        OpName[] values = OpName.values();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                sb.append("|");
            }
            sb.append((Object)values[i]);
        }
        sb.append(")");
        OP_FILE_PATTERN = Pattern.compile(sb.toString());
    }
}

