/*
 * Decompiled with CFR 0.152.
 */
package org.brutusin.wava.core.plug.impl;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.PersistenceConfiguration;
import org.brutusin.wava.core.cfg.Config;
import org.brutusin.wava.core.plug.LinuxCommands;

public final class CachingLinuxCommands
extends LinuxCommands {
    private final LinuxCommands commands;
    private final Cache cache;

    public CachingLinuxCommands(LinuxCommands commands) {
        this.commands = commands;
        CacheManager cm = CacheManager.create();
        this.cache = new Cache(new CacheConfiguration(CachingLinuxCommands.class.getName() + "-cache", 0).timeToLiveSeconds((long)Config.getInstance().getSchedulerCfg().getCommandTTLCacheSecs()).persistence(new PersistenceConfiguration().strategy(PersistenceConfiguration.Strategy.NONE)));
        cm.addCache(this.cache);
    }

    @Override
    public void setNiceness(int pId, int niceness) throws IOException, InterruptedException {
        this.commands.setNiceness(pId, niceness);
    }

    @Override
    public void setImmutable(File f, boolean immutable) throws IOException, InterruptedException {
        this.commands.setImmutable(f, immutable);
    }

    @Override
    public void killTree(int pid) throws IOException, InterruptedException {
        this.commands.killTree(pid);
    }

    @Override
    public String[] decorateWithCPUAffinity(String[] cmd, String affinity) {
        return this.commands.decorateWithCPUAffinity(cmd, affinity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getTreeRSS(int[] pIds) throws IOException, InterruptedException {
        String key = Arrays.toString(pIds);
        Element element = this.cache.get((Serializable)((Object)key));
        if (element == null) {
            Cache cache = this.cache;
            synchronized (cache) {
                element = this.cache.get((Serializable)((Object)key));
                if (element == null) {
                    long[] ret = this.commands.getTreeRSS(pIds);
                    element = new Element((Serializable)((Object)key), (Serializable)ret);
                    this.cache.put(element);
                }
            }
        }
        return (long[])element.getObjectValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSystemRSSUsedMemory() throws IOException, InterruptedException {
        String key = "getSystemRSSUsedMemory";
        Element element = this.cache.get((Serializable)((Object)key));
        if (element == null) {
            Cache cache = this.cache;
            synchronized (cache) {
                element = this.cache.get((Serializable)((Object)key));
                if (element == null) {
                    long value = this.commands.getSystemRSSUsedMemory();
                    element = new Element((Serializable)((Object)key), (Serializable)Long.valueOf(value));
                    this.cache.put(element);
                }
            }
        }
        return (Long)element.getObjectValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSystemRSSFreeMemory() throws IOException, InterruptedException {
        String key = "getSystemRSSFreeMemory";
        Element element = this.cache.get((Serializable)((Object)key));
        if (element == null) {
            Cache cache = this.cache;
            synchronized (cache) {
                element = this.cache.get((Serializable)((Object)key));
                if (element == null) {
                    long value = this.commands.getSystemRSSFreeMemory();
                    element = new Element((Serializable)((Object)key), (Serializable)Long.valueOf(value));
                    this.cache.put(element);
                }
            }
        }
        return (Long)element.getObjectValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSystemRSSMemory() throws IOException, InterruptedException {
        String key = "getSystemRSSMemory";
        Element element = this.cache.get((Serializable)((Object)key));
        if (element == null) {
            Cache cache = this.cache;
            synchronized (cache) {
                element = this.cache.get((Serializable)((Object)key));
                if (element == null) {
                    long value = this.commands.getSystemRSSMemory();
                    element = new Element((Serializable)((Object)key), (Serializable)Long.valueOf(value));
                    this.cache.put(element);
                }
            }
        }
        return (Long)element.getObjectValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFileOwner(File f) throws IOException, InterruptedException {
        String key = f.getAbsolutePath();
        Element element = this.cache.get((Serializable)((Object)key));
        if (element == null) {
            Cache cache = this.cache;
            synchronized (cache) {
                element = this.cache.get((Serializable)((Object)key));
                if (element == null) {
                    String value = this.commands.getFileOwner(f);
                    element = new Element((Serializable)((Object)key), (Serializable)((Object)value));
                    this.cache.put(element);
                }
            }
        }
        return (String)element.getObjectValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRunningUser() throws IOException, InterruptedException {
        String key = "getRunningUser";
        Element element = this.cache.get((Serializable)((Object)key));
        if (element == null) {
            Cache cache = this.cache;
            synchronized (cache) {
                element = this.cache.get((Serializable)((Object)key));
                if (element == null) {
                    String value = this.commands.getRunningUser();
                    element = new Element((Serializable)((Object)key), (Serializable)((Object)value));
                    element.setEternal(true);
                    this.cache.put(element);
                }
            }
        }
        return (String)element.getObjectValue();
    }

    @Override
    public String[] getRunAsCommand(String user, String[] cmd) {
        return this.commands.getRunAsCommand(user, cmd);
    }

    @Override
    public void createNamedPipes(File ... files) throws IOException, InterruptedException {
        this.commands.createNamedPipes(files);
    }
}

