/*
 * Decompiled with CFR 0.152.
 */
package org.brutusin.wava.core.plug.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.brutusin.commons.utils.Miscellaneous;
import org.brutusin.commons.utils.ProcessException;
import org.brutusin.commons.utils.ProcessUtils;
import org.brutusin.wava.core.cfg.Config;
import org.brutusin.wava.core.plug.LinuxCommands;

public final class POSIXCommandsImpl
extends LinuxCommands {
    private static String executeBashCommand(String command) throws IOException, InterruptedException {
        String[] cmd = new String[]{"/bin/bash", "-c", command};
        Process p = Runtime.getRuntime().exec(cmd);
        String[] ret = ProcessUtils.execute((Process)p);
        return ret[0];
    }

    @Override
    public void setNiceness(int pId, int niceness) throws IOException, InterruptedException {
        try {
            String[] cmd = new String[]{"renice", "-n", String.valueOf(niceness), "-p", String.valueOf(pId)};
            Runtime.getRuntime().exec(cmd);
            Process p = Runtime.getRuntime().exec(cmd);
            ProcessUtils.execute((Process)p);
            Process getChildrenProcess = Runtime.getRuntime().exec(new String[]{"ps", "-o", "pid", "--no-headers", "--ppid", String.valueOf(pId)});
            String output = ProcessUtils.execute((Process)getChildrenProcess)[0];
            if (output != null) {
                String[] childrenIds;
                for (String childrenId : childrenIds = output.split("\n")) {
                    this.setNiceness(Integer.valueOf(childrenId.trim()), niceness);
                }
            }
        }
        catch (ProcessException processException) {
            // empty catch block
        }
    }

    @Override
    public void setImmutable(File f, boolean immutable) throws IOException, InterruptedException {
        String[] cmd = new String[]{"chattr", immutable ? "+i" : "-i", f.getAbsolutePath()};
        Process p = Runtime.getRuntime().exec(cmd);
        ProcessUtils.execute((Process)p);
    }

    @Override
    public void killTree(final int pId) throws IOException, InterruptedException {
        Thread t1 = new Thread(){

            @Override
            public void run() {
                try {
                    HashSet<Integer> visitedIds = new HashSet<Integer>();
                    POSIXCommandsImpl.this.getTree(visitedIds, pId, false);
                    POSIXCommandsImpl.this.kill(visitedIds, 15);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        t1.setName("SIGTERM " + pId);
        t1.start();
        Thread t2 = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000 * Config.getInstance().getSchedulerCfg().getSigKillDelaySecs());
                    HashSet<Integer> visitedIds = new HashSet<Integer>();
                    POSIXCommandsImpl.this.getTree(visitedIds, pId, true);
                    POSIXCommandsImpl.this.kill(visitedIds, 9);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        t2.setName("SIGKILL " + pId);
        t2.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getTree(Set<Integer> visited, int pId, boolean stop) throws InterruptedException {
        try {
            Process getChildrenProcess;
            String output;
            if (stop) {
                Process stopProcess = Runtime.getRuntime().exec(new String[]{"kill", "-stop", String.valueOf(pId)});
                ProcessUtils.execute((Process)stopProcess);
            }
            if ((output = ProcessUtils.execute((Process)(getChildrenProcess = Runtime.getRuntime().exec(new String[]{"ps", "-o", "pid", "--no-headers", "--ppid", String.valueOf(pId)})))[0]) != null) {
                String[] pIds = output.split("\n");
                for (int i = 0; i < pIds.length; ++i) {
                    this.getTree(visited, Integer.valueOf(pIds[i].trim()), stop);
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof InterruptedException) {
                throw (InterruptedException)ex;
            }
        }
        finally {
            visited.add(pId);
        }
    }

    private void kill(Set<Integer> pIds, int signal) throws InterruptedException {
        block3: {
            try {
                String[] cmd = new String[3 + pIds.size()];
                cmd[0] = "kill";
                cmd[1] = "-s";
                cmd[2] = String.valueOf(signal);
                Iterator<Integer> it = pIds.iterator();
                for (int i = 3; i < cmd.length; ++i) {
                    cmd[i] = String.valueOf(it.next());
                }
                Process p = Runtime.getRuntime().exec(cmd);
                ProcessUtils.execute((Process)p);
            }
            catch (Exception ex) {
                if (!(ex instanceof InterruptedException)) break block3;
                throw (InterruptedException)ex;
            }
        }
    }

    @Override
    public long getSystemRSSUsedMemory() throws IOException, InterruptedException {
        return this.getSystemRSSMemory() - this.getSystemRSSFreeMemory();
    }

    @Override
    public long[] getTreeRSS(int[] pIds) throws IOException, InterruptedException {
        String stdout;
        long[] ret = new long[pIds.length];
        HashMap<Integer, Integer> indexes = new HashMap<Integer, Integer>();
        for (int i = 0; i < pIds.length; ++i) {
            indexes.put(pIds[i], i);
        }
        String[] cmd = new String[]{"ps", "axo", "pid,ppid,rss", "--no-headers", "--sort=start_time"};
        Process p = Runtime.getRuntime().exec(cmd);
        try {
            stdout = ProcessUtils.execute((Process)p)[0];
        }
        catch (RuntimeException ex) {
            return null;
        }
        if (stdout != null) {
            String[] lines;
            for (String line : lines = stdout.split("\n")) {
                Integer ppid;
                String[] cols = line.trim().split("\\s+");
                Integer pid = Integer.valueOf(cols[0].trim());
                Integer index = (Integer)indexes.get(pid);
                if (index == null && (index = (Integer)indexes.get(ppid = Integer.valueOf(cols[1].trim()))) != null) {
                    indexes.put(pid, index);
                }
                if (index == null) continue;
                int n = index;
                ret[n] = ret[n] + Long.valueOf(cols[2].trim()) * 1000L;
            }
        }
        return ret;
    }

    @Override
    public String[] decorateWithCPUAffinity(String[] cmd, String affinity) {
        String[] ret = new String[cmd.length + 3];
        ret[0] = "taskset";
        ret[1] = "-c";
        ret[2] = affinity;
        for (int i = 3; i < ret.length; ++i) {
            ret[i] = cmd[i - 3];
        }
        return ret;
    }

    @Override
    public long getSystemRSSFreeMemory() throws IOException, InterruptedException {
        String ouput = POSIXCommandsImpl.executeBashCommand("echo $((`cat /proc/meminfo | grep ^Cached:| awk '{print $2}'` + `cat /proc/meminfo | grep ^MemFree:| awk '{print $2}'` ))");
        return Long.valueOf(ouput.trim()) * 1000L;
    }

    @Override
    public long getSystemRSSMemory() throws IOException, InterruptedException {
        String ouput = POSIXCommandsImpl.executeBashCommand("cat /proc/meminfo | grep ^MemTotal:| awk '{print $2}'");
        return Long.valueOf(ouput.trim()) * 1000L;
    }

    @Override
    public String[] getRunAsCommand(String user, String[] cmd) {
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < cmd.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append("\"").append(cmd[i]).append("\"");
        }
        return new String[]{"runuser", "-p", user, "-c", sb.toString()};
    }

    @Override
    public String getRunningUser() throws IOException, InterruptedException {
        String[] cmd = new String[]{"id", "-un"};
        Process p = Runtime.getRuntime().exec(cmd);
        return ProcessUtils.execute((Process)p)[0];
    }

    @Override
    public void createNamedPipes(File ... files) throws IOException, InterruptedException {
        String[] mkfifo = new String[files.length + 1];
        String[] chmod = new String[files.length + 2];
        mkfifo[0] = "mkfifo";
        chmod[0] = "chmod";
        chmod[1] = "777";
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (!f.getParentFile().exists()) {
                Miscellaneous.createDirectory((File)f.getParentFile());
            }
            mkfifo[i + 1] = f.getAbsolutePath();
            chmod[i + 2] = f.getAbsolutePath();
        }
        Process p = Runtime.getRuntime().exec(mkfifo);
        ProcessUtils.execute((Process)p);
        p = Runtime.getRuntime().exec(chmod);
        ProcessUtils.execute((Process)p);
    }

    @Override
    public String getFileOwner(File f) throws IOException, InterruptedException {
        return POSIXCommandsImpl.executeBashCommand("ls -ld \"" + f.getAbsolutePath() + "\" | awk 'NR==1 {print $3}'");
    }
}

