/*
 * Decompiled with CFR 0.152.
 */
package org.brutusin.wava.main;

import java.io.File;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.brutusin.wava.core.Environment;
import org.brutusin.wava.main.AboutMain;
import org.brutusin.wava.main.CoreMain;
import org.brutusin.wava.main.peer.CancelMain;
import org.brutusin.wava.main.peer.GroupMain;
import org.brutusin.wava.main.peer.ListJobsMain;
import org.brutusin.wava.main.peer.StatusMain;
import org.brutusin.wava.main.peer.SubmitMain;
import org.brutusin.wava.utils.ANSICode;
import org.brutusin.wava.utils.NonRootUserException;
import org.brutusin.wava.utils.RetCode;
import org.brutusin.wava.utils.Utils;

public class WavaMain {
    private static void showHelp(Options options) {
        Utils.showHelp(options, "wava [option]");
    }

    public static void main(String[] args) throws Exception {
        Options options = new Options();
        Option hOpt = Option.builder((String)"h").longOpt("help").desc("print this message").build();
        Option aOpt = Option.builder((String)"a").longOpt("about").desc("information about the program").build();
        Option sOpt = Option.builder((String)"s").longOpt("start").desc("start core scheduler process").build();
        Option uOpt = Option.builder((String)"u").longOpt("update").desc("update to lastest version").build();
        Option rOpt = Option.builder((String)"r").longOpt("run").desc("enqueue a job to be executed when enough physical memory is available").build();
        Option jOpt = Option.builder((String)"j").longOpt("jobs").desc("view jobs").build();
        Option gOpt = Option.builder((String)"g").longOpt("group").desc("group management commands").build();
        Option cOpt = Option.builder((String)"c").longOpt("cancel").desc("cancel a running or enqueued job").build();
        Option tOpt = Option.builder((String)"t").longOpt("status").desc("return core service status").build();
        options.addOption(aOpt);
        options.addOption(hOpt);
        options.addOption(sOpt);
        options.addOption(rOpt);
        options.addOption(gOpt);
        options.addOption(jOpt);
        options.addOption(cOpt);
        options.addOption(uOpt);
        options.addOption(tOpt);
        try {
            if (args.length > 0) {
                DefaultParser parser = new DefaultParser();
                CommandLine cl = parser.parse(options, Arrays.copyOfRange(args, 0, 1));
                String[] subArgs = args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{};
                if (cl.hasOption(aOpt.getOpt())) {
                    AboutMain.main(subArgs);
                } else if (cl.hasOption(hOpt.getOpt())) {
                    WavaMain.showHelp(options);
                } else if (cl.hasOption(sOpt.getOpt())) {
                    CoreMain.main(subArgs);
                } else if (cl.hasOption(jOpt.getOpt())) {
                    ListJobsMain.main(subArgs);
                } else if (cl.hasOption(gOpt.getOpt())) {
                    GroupMain.main(subArgs);
                } else if (cl.hasOption(rOpt.getOpt())) {
                    SubmitMain.main(subArgs);
                } else if (cl.hasOption(cOpt.getOpt())) {
                    CancelMain.main(args);
                } else if (cl.hasOption(uOpt.getOpt())) {
                    System.err.println("run the following script for updating: " + (Object)((Object)ANSICode.CYAN) + new File(Environment.ROOT, "bin/wava-update").getAbsolutePath() + (Object)((Object)ANSICode.RESET));
                } else if (cl.hasOption(tOpt.getOpt())) {
                    StatusMain.main(args);
                }
            } else {
                WavaMain.showHelp(options);
            }
        }
        catch (ParseException exp) {
            System.err.println((Object)((Object)ANSICode.RED) + "Parsing failed.  Reason: " + exp.getMessage() + (Object)((Object)ANSICode.RESET) + "\n");
            WavaMain.showHelp(options);
            System.exit(RetCode.ERROR.getCode());
        }
        catch (NonRootUserException nex) {
            System.err.println((Object)((Object)ANSICode.RED) + "Only 'root' user can run this command" + (Object)((Object)ANSICode.RESET));
            System.exit(RetCode.ERROR.getCode());
        }
        catch (Error err) {
            System.err.println((Object)((Object)ANSICode.RED) + "Severe error: " + err.getMessage() + (Object)((Object)ANSICode.RESET));
            System.exit(RetCode.ERROR.getCode());
        }
    }
}

