/*
 * Decompiled with CFR 0.152.
 */
package org.brutusin.wava.main.peer;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.brutusin.wava.core.io.OpName;
import org.brutusin.wava.core.io.RequestExecutor;
import org.brutusin.wava.input.CancelInput;
import org.brutusin.wava.utils.RetCode;
import org.brutusin.wava.utils.Utils;

public class CancelMain {
    public static final String DESCRIPTION = "cancel a running or enqueued job";

    private static CancelInput getRequest(String[] args) {
        Options options = new Options();
        Option cOpt = Option.builder((String)"c").argName("job id").hasArg().required().build();
        options.addOption(cOpt);
        try {
            int id;
            DefaultParser parser = new DefaultParser();
            CommandLine cl = parser.parse(options, args);
            try {
                id = Integer.valueOf(cl.getOptionValue(cOpt.getOpt()));
            }
            catch (NumberFormatException ex) {
                throw new ParseException("Invalid job id value");
            }
            CancelInput ci = new CancelInput();
            ci.setId(id);
            return ci;
        }
        catch (ParseException exp) {
            System.err.println("Parsing failed.  Reason: " + exp.getMessage() + "\n");
            CancelMain.showHelp(options);
            return null;
        }
    }

    private static void showHelp(Options options) {
        Utils.showHelp(options, "wava -c <job-id>\ncancel a running or enqueued job");
    }

    public static void main(String[] args) throws Exception {
        Utils.validateCoreRunning();
        CancelInput ci = CancelMain.getRequest(args);
        Integer retCode = null;
        if (ci != null) {
            retCode = RequestExecutor.executeRequest(OpName.cancel, ci, null, false);
        }
        if (retCode == null) {
            retCode = RetCode.ERROR.getCode();
        }
        System.exit(retCode);
    }
}

