/*
 * Decompiled with CFR 0.152.
 */
package org.brutusin.wava.main.peer;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.brutusin.wava.core.io.OpName;
import org.brutusin.wava.core.io.RequestExecutor;
import org.brutusin.wava.input.GroupInput;
import org.brutusin.wava.utils.RetCode;
import org.brutusin.wava.utils.Utils;

public class GroupMain {
    public static final String DESCRIPTION = "group management commands";

    private static void showHelp(Options options) {
        Utils.showHelp(options, "wava -g [options]\ngroup management commands");
    }

    private static GroupInput getRequest(String[] args) {
        Options options = new Options();
        Option nOpt = Option.builder((String)"n").longOpt("name").argName("group name").desc("name of the group to be created or updated.").hasArg().build();
        Option dOpt = Option.builder((String)"d").longOpt("delete").desc("deletes an existing empty group").build();
        Option lOpt = Option.builder((String)"l").longOpt("list").desc("list existing groups").build();
        Option hOpt = Option.builder((String)"h").longOpt("no-headers").desc("do not output headers").build();
        Option pOpt = Option.builder((String)"p").longOpt("priority").argName("integer").desc("priority").hasArg().build();
        Option tOpt = Option.builder((String)"t").longOpt("idle").argName("integer").desc("time to idle. Elapsed time since the last executing job of the group finishes and the group is deleted. Default is -1, meaning that the group to be created is eternal").hasArg().build();
        options.addOption(dOpt);
        options.addOption(nOpt);
        options.addOption(pOpt);
        options.addOption(tOpt);
        options.addOption(lOpt);
        options.addOption(hOpt);
        try {
            DefaultParser parser = new DefaultParser();
            CommandLine cl = parser.parse(options, args);
            GroupInput gi = new GroupInput();
            if (cl.hasOption(nOpt.getOpt())) {
                gi.setGroupName(cl.getOptionValue(nOpt.getOpt()));
                if (cl.hasOption(dOpt.getOpt())) {
                    gi.setDelete(true);
                } else {
                    if (cl.hasOption(pOpt.getOpt())) {
                        try {
                            gi.setPriority(Integer.valueOf(cl.getOptionValue(pOpt.getOpt())));
                        }
                        catch (NumberFormatException ex) {
                            throw new ParseException("Invalid " + pOpt.getOpt() + " value");
                        }
                    }
                    if (cl.hasOption(tOpt.getOpt())) {
                        try {
                            gi.setTimetoIdleSeconds(Integer.valueOf(cl.getOptionValue(tOpt.getOpt())));
                        }
                        catch (NumberFormatException ex) {
                            throw new ParseException("Invalid " + tOpt.getOpt() + " value");
                        }
                    } else {
                        gi.setTimetoIdleSeconds(-1);
                    }
                }
            } else if (cl.hasOption(lOpt.getOpt())) {
                gi.setList(true);
                if (cl.hasOption(hOpt.getOpt())) {
                    gi.setNoHeaders(true);
                }
            } else {
                GroupMain.showHelp(options);
                return null;
            }
            return gi;
        }
        catch (ParseException exp) {
            System.err.println("Parsing failed.  Reason: " + exp.getMessage() + "\n");
            GroupMain.showHelp(options);
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        Utils.validateCoreRunning();
        GroupInput gi = GroupMain.getRequest(args);
        if (gi == null) {
            System.exit(RetCode.ERROR.getCode());
        }
        System.exit(RequestExecutor.executeRequest(OpName.group, gi, null, false));
    }
}

