/*
 * Decompiled with CFR 0.152.
 */
package org.brutusin.wava.main.peer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.brutusin.commons.Pair;
import org.brutusin.commons.utils.Miscellaneous;
import org.brutusin.wava.core.io.OpName;
import org.brutusin.wava.core.io.RequestExecutor;
import org.brutusin.wava.input.SubmitInput;
import org.brutusin.wava.utils.RetCode;
import org.brutusin.wava.utils.Utils;

public class SubmitMain {
    public static final String DESCRIPTION = "enqueue a job to be executed when enough physical memory is available";

    private static void showHelp(Options options) {
        Utils.showHelp(options, "wava -r [options] [command]\nenqueue a job to be executed when enough physical memory is available");
    }

    private static int getCommandStart(String[] args) {
        for (int i = 0; i < args.length; i += 2) {
            if (args[i].startsWith("-")) continue;
            return i;
        }
        return args.length;
    }

    private static Pair<SubmitInput, File> getRequest(String[] args) {
        Options options = new Options();
        Option hOpt = new Option("h", "print this message");
        Option mOpt = Option.builder((String)"m").argName("mem value").hasArg().desc("promised maximum RSS memory to be allocated by the process at any time, in bytes, if no unit is specified").required().build();
        Option eOpt = Option.builder((String)"e").argName("file").hasArg().desc("file to send execution events. If null, then stderr will be used").build();
        Option gOpt = Option.builder((String)"g").argName("group id").hasArg().desc("priority group of the execution. Jobs of the same group follow a FIFO ordering").build();
        options.addOption(hOpt);
        options.addOption(mOpt);
        options.addOption(gOpt);
        options.addOption(eOpt);
        int commandStart = SubmitMain.getCommandStart(args);
        try {
            long memory;
            DefaultParser parser = new DefaultParser();
            CommandLine cl = parser.parse(options, Arrays.copyOfRange(args, 0, commandStart));
            if (commandStart == args.length) {
                System.err.println("A command is required");
                SubmitMain.showHelp(options);
                return null;
            }
            if (cl.hasOption(hOpt.getOpt())) {
                SubmitMain.showHelp(options);
                return null;
            }
            File eventFile = cl.hasOption(eOpt.getOpt()) ? new File(cl.getOptionValue(eOpt.getOpt())) : null;
            try {
                memory = Miscellaneous.parseHumanReadableByteCount((String)cl.getOptionValue(mOpt.getOpt()));
            }
            catch (IllegalArgumentException ex) {
                throw new ParseException("Invalid memory (-" + mOpt.getOpt() + ") value");
            }
            SubmitInput ri = new SubmitInput();
            String envJobId = System.getenv("WAVA_JOB_ID");
            if (envJobId != null) {
                ri.setParentId(Integer.valueOf(envJobId));
            }
            ri.setCommand(Arrays.copyOfRange(args, commandStart, args.length));
            ri.setMaxRSS(memory);
            ri.setWorkingDirectory(new File(""));
            ri.setEnvironment(System.getenv());
            if (cl.hasOption(gOpt.getOpt())) {
                String group = cl.getOptionValue(gOpt.getOpt());
                ri.setGroupName(group);
            }
            return new Pair((Object)ri, (Object)eventFile);
        }
        catch (ParseException exp) {
            System.err.println("Parsing failed.  Reason: " + exp.getMessage() + "\n");
            SubmitMain.showHelp(options);
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        boolean prettyEvents;
        OutputStream eventOs;
        Utils.validateCoreRunning();
        Pair<SubmitInput, File> pair = SubmitMain.getRequest(args);
        if (pair == null) {
            System.exit(RetCode.ERROR.getCode());
        }
        if (pair.getElement2() == null) {
            eventOs = System.err;
            prettyEvents = true;
        } else {
            eventOs = new FileOutputStream((File)pair.getElement2());
            prettyEvents = false;
        }
        Integer retCode = RequestExecutor.executeRequest(OpName.submit, pair.getElement1(), eventOs, prettyEvents);
        if (retCode == null) {
            retCode = RetCode.ERROR.getCode();
        }
        System.exit(retCode);
    }
}

