/*
 * Decompiled with CFR 0.152.
 */
package org.brutusin.wava.utils;

import org.brutusin.wava.core.cfg.Config;

public enum ANSICode {
    BLACK("\u001b[30m"),
    RED("\u001b[31m"),
    GREEN("\u001b[32m"),
    YELLOW("\u001b[33m"),
    BLUE("\u001b[34m"),
    PURPLE("\u001b[35m"),
    CYAN("\u001b[36m"),
    WHITE("\u001b[37m"),
    BG_GREEN("\u001b[42m"),
    BG_BLACK("\u001b[40m"),
    BG_RED("\u001b[41m"),
    BG_YELLOW("\u001b[43m"),
    BG_BLUE("\u001b[44m"),
    BG_MAGENTA("\u001b[45m"),
    BG_CYAN("\u001b[46m"),
    BG_WHITE("\u001b[47m"),
    RESET("\u001b[0m"),
    BOLD("\u001b[1m"),
    UNDERLINED("\u001b[4m"),
    BLINK("\u001b[5m"),
    REVERSED("\u001b[7m"),
    INVISIBLE("\u001b[8m"),
    END_OF_LINE("\u001b[K"),
    MOVE_TO_TOP("\u001b[0;0f"),
    NO_WRAP("\u001b[?7l"),
    WRAP("\u001b[?7h"),
    CLEAR("\u001b[2J");

    private final String code;
    private static final ThreadLocal<Boolean> ACTIVE;

    private ANSICode(String code) {
        this.code = code;
    }

    public static void setActive(boolean active) {
        ACTIVE.set(active && Config.getInstance().getuICfg().isAnsiColors());
    }

    public static boolean isActive() {
        return ACTIVE.get();
    }

    public String getCode() {
        if (ANSICode.isActive()) {
            return this.code;
        }
        return "";
    }

    public String toString() {
        return this.getCode();
    }

    static {
        ACTIVE = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Config.getInstance().getuICfg().isAnsiColors();
            }
        };
    }
}

