/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.async;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface AsyncGenerator<E>
extends Iterable<E> {
    public Data<E> next();

    public static <E> AsyncGenerator<E> empty() {
        return Data::done;
    }

    public static <E, U> AsyncGenerator<U> map(Iterator<E> iterator, Function<E, CompletableFuture<U>> mapFunction) {
        return () -> {
            if (!iterator.hasNext()) {
                return Data.done();
            }
            return Data.of((CompletableFuture)mapFunction.apply(iterator.next()));
        };
    }

    public static <E, U> AsyncGenerator<U> collect(Iterator<E> iterator, BiConsumer<E, Consumer<CompletableFuture<U>>> consumer) {
        ArrayList accumulator = new ArrayList();
        Consumer<CompletableFuture> addElement = accumulator::add;
        while (iterator.hasNext()) {
            consumer.accept(iterator.next(), addElement);
        }
        Iterator it = accumulator.iterator();
        return () -> {
            if (!it.hasNext()) {
                return Data.done();
            }
            return Data.of((CompletableFuture)it.next());
        };
    }

    public static <E, U> AsyncGenerator<U> map(Collection<E> collection, Function<E, CompletableFuture<U>> mapFunction) {
        if (collection == null || collection.isEmpty()) {
            return AsyncGenerator.empty();
        }
        return AsyncGenerator.map(collection.iterator(), mapFunction);
    }

    public static <E, U> AsyncGenerator<U> collect(Collection<E> collection, BiConsumer<E, Consumer<CompletableFuture<U>>> consumer) {
        if (collection == null || collection.isEmpty()) {
            return AsyncGenerator.empty();
        }
        return AsyncGenerator.collect(collection.iterator(), consumer);
    }

    default public CompletableFuture<Void> toCompletableFuture() {
        Data<E> next = this.next();
        if (next.done) {
            return CompletableFuture.completedFuture(null);
        }
        return next.data.thenCompose(v -> this.toCompletableFuture());
    }

    default public CompletableFuture<Void> forEachAsync(Consumer<E> consumer) {
        Data<E> next = this.next();
        if (next.done) {
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)next.data.thenApply(v -> {
            consumer.accept(v);
            return null;
        })).thenCompose(v -> this.forEachAsync(consumer));
    }

    default public <R extends List<E>> CompletableFuture<R> collectAsync(R result, Consumer<E> consumer) {
        Data<E> next = this.next();
        if (next.done) {
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)next.data.thenApply(v -> {
            consumer.accept(v);
            result.add(v);
            return null;
        })).thenCompose(v -> this.collectAsync(result, consumer));
    }

    default public Stream<E> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 16), false);
    }

    @Override
    default public Iterator<E> iterator() {
        return new Iterator<E>(){
            private final AtomicReference<Data<E>> currentFetchedData = new AtomicReference();
            {
                this.currentFetchedData.set(AsyncGenerator.this.next());
            }

            @Override
            public boolean hasNext() {
                Data value = this.currentFetchedData.get();
                return value != null && !value.done;
            }

            @Override
            public E next() {
                Data next = this.currentFetchedData.get();
                if (next == null || next.done) {
                    throw new IllegalStateException("no more elements into iterator");
                }
                next = this.currentFetchedData.getAndUpdate(v -> AsyncGenerator.this.next());
                return next.data.join();
            }
        };
    }

    public static class Data<E> {
        final CompletableFuture<E> data;
        final boolean done;

        public Data(CompletableFuture<E> data, boolean done) {
            this.data = data;
            this.done = done;
        }

        public static <E> Data<E> of(CompletableFuture<E> data) {
            return new Data<E>(data, false);
        }

        public static <E> Data<E> done() {
            return new Data<E>(null, true);
        }
    }
}

