/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.async;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.bsc.async.AsyncGenerator;

public interface AsyncGeneratorOperators<E> {
    public AsyncGenerator.Data<E> next();

    default public Executor executor() {
        return Runnable::run;
    }

    default public <U> AsyncGenerator<U> map(Function<E, U> mapFunction) {
        return () -> {
            AsyncGenerator.Data<E> next = this.next();
            if (next.isDone()) {
                return AsyncGenerator.Data.done(next.resultValue);
            }
            return AsyncGenerator.Data.of(next.data.thenApplyAsync(mapFunction, this.executor()));
        };
    }

    default public <U> AsyncGenerator<U> flatMap(Function<E, CompletableFuture<U>> mapFunction) {
        return () -> {
            AsyncGenerator.Data<E> next = this.next();
            if (next.isDone()) {
                return AsyncGenerator.Data.done(next.resultValue);
            }
            return AsyncGenerator.Data.of(next.data.thenComposeAsync(mapFunction, this.executor()));
        };
    }

    default public AsyncGenerator<E> filter(Predicate<E> predicate) {
        return () -> {
            AsyncGenerator.Data<E> next = this.next();
            while (!next.isDone()) {
                Object value = next.data.join();
                if (predicate.test(value)) {
                    return next;
                }
                next = this.next();
            }
            return AsyncGenerator.Data.done(next.resultValue);
        };
    }

    private CompletableFuture<Object> forEachAsyncNested(Consumer<E> consumer) {
        AsyncGenerator.Data<E> next = this.next();
        if (next.isDone()) {
            return CompletableFuture.completedFuture(next.resultValue);
        }
        if (next.embed != null) {
            return next.embed.generator.forEachAsync(consumer).thenCompose(v -> this.forEachAsyncNested(consumer));
        }
        return ((CompletableFuture)next.data.thenApply(v -> {
            consumer.accept(v);
            return null;
        })).thenCompose(v -> this.forEachAsyncNested(consumer));
    }

    default public CompletableFuture<Object> forEachAsync(Consumer<E> consumer) {
        return CompletableFuture.supplyAsync(() -> {
            AsyncGenerator.Data<E> next = this.next();
            if (next.isDone()) {
                return next.resultValue;
            }
            if (next.embed != null) {
                return next.embed.generator.forEachAsync(consumer).thenCompose(v -> this.forEachAsyncNested(consumer));
            }
            return ((CompletableFuture)((CompletableFuture)next.data.thenApply(v -> {
                consumer.accept(v);
                return null;
            })).thenCompose(v -> this.forEachAsyncNested(consumer))).join();
        }, this.executor());
    }

    private <R extends List<E>> CompletableFuture<R> collectAsyncNested(R result, BiConsumer<R, E> consumer) {
        AsyncGenerator.Data<E> next = this.next();
        if (next.isDone()) {
            return CompletableFuture.completedFuture(result);
        }
        return ((CompletableFuture)next.data.thenApply(v -> {
            consumer.accept(result, v);
            return null;
        })).thenCompose(v -> this.collectAsyncNested(result, consumer));
    }

    default public <R extends List<E>> CompletableFuture<R> collectAsync(R result, BiConsumer<R, E> consumer) {
        return CompletableFuture.supplyAsync(() -> {
            AsyncGenerator.Data<E> next = this.next();
            if (next.isDone()) {
                return result;
            }
            return (List)((CompletableFuture)((CompletableFuture)next.data.thenApply(v -> {
                consumer.accept(result, v);
                return null;
            })).thenCompose(v -> this.collectAsyncNested(result, consumer))).join();
        }, this.executor());
    }
}

