/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.async;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.bsc.async.AsyncGenerator;

class Mapper<E, U>
extends AsyncGenerator.BaseCancellable<U>
implements AsyncGenerator.HasResultValue {
    protected final AsyncGenerator<E> delegate;
    final Function<E, U> mapFunction;
    private Object resultValue;

    protected Mapper(AsyncGenerator<E> delegate, Function<E, U> mapFunction) {
        this.delegate = Objects.requireNonNull(delegate, "delegate cannot be null");
        this.mapFunction = Objects.requireNonNull(mapFunction, "mapFunction cannot be null");
    }

    @Override
    public final Executor executor() {
        return this.delegate.executor();
    }

    @Override
    public Optional<Object> resultValue() {
        return Optional.ofNullable(this.resultValue);
    }

    @Override
    public final AsyncGenerator.Data<U> next() {
        if (this.isCancelled()) {
            throw new CancellationException("generator is cancelled");
        }
        AsyncGenerator.Data<E> next = this.delegate.next();
        if (next.isDone()) {
            this.resultValue = next.resultValue();
            return AsyncGenerator.Data.done(next.resultValue());
        }
        return AsyncGenerator.Data.of(next.future().thenApply((Function)this.mapFunction));
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (super.cancel(mayInterruptIfRunning)) {
            ExecutorService service;
            Executor executor;
            AsyncGenerator<E> asyncGenerator = this.delegate;
            if (asyncGenerator instanceof AsyncGenerator.IsCancellable) {
                AsyncGenerator.IsCancellable isCancellable = (AsyncGenerator.IsCancellable)((Object)asyncGenerator);
                return isCancellable.cancel(mayInterruptIfRunning);
            }
            if (mayInterruptIfRunning && (executor = this.delegate.executor()) instanceof ExecutorService && !(service = (ExecutorService)executor).isShutdown() && !service.isTerminated()) {
                service.shutdownNow();
                return true;
            }
        }
        return false;
    }
}

