/*
 * Decompiled with CFR 0.152.
 */
package org.javascript.rhino;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public abstract class AbstractRhinoTopLevel
extends ImporterTopLevel {
    private static final String CLASSPATH_PREFIX = "classpath:";
    private final Set<String> moduleCache = new HashSet<String>();

    protected static <T extends AbstractRhinoTopLevel> T deref(Scriptable thisObj) {
        AbstractRhinoTopLevel _this = null;
        if (thisObj instanceof AbstractRhinoTopLevel) {
            _this = (AbstractRhinoTopLevel)thisObj;
        } else {
            Scriptable protoObj = thisObj.getPrototype();
            if (protoObj instanceof AbstractRhinoTopLevel) {
                _this = (AbstractRhinoTopLevel)protoObj;
            } else {
                throw new IllegalStateException("cannot deref thisObj to  AbstractRhinoTopLevel!");
            }
        }
        return (T)((Object)_this);
    }

    protected void _print(PrintWriter out, Context cx, Object[] args, Function funObj) {
        if (args == null) {
            return;
        }
        int row = 0;
        for (Object arg : args) {
            if (row++ > 0) {
                out.print(" ");
            }
            out.print(Context.toString((Object)arg));
        }
        out.println();
        out.flush();
    }

    private String normalizeModuleName(String moduleName) {
        if (moduleName.startsWith(CLASSPATH_PREFIX)) {
            return moduleName.substring(CLASSPATH_PREFIX.length());
        }
        return moduleName;
    }

    protected void _load(Context cx, Object[] args, Function funObj) throws Exception {
        Object arg;
        String module;
        if (args == null) {
            return;
        }
        Object[] objectArray = args;
        int n = objectArray.length;
        for (int i = 0; i < n && !this.moduleCache.contains(module = this.normalizeModuleName(Context.toString((Object)(arg = objectArray[i])))); ++i) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            InputStream is = cl.getResourceAsStream(module);
            if (is != null) {
                try {
                    cx.evaluateReader((Scriptable)this, (Reader)new InputStreamReader(is), module, 0, null);
                    this.moduleCache.add(module);
                    continue;
                }
                catch (IOException e) {
                    throw new Exception(String.format("error evaluating module [%s]", module), e);
                }
            }
            File file = new File(module);
            if (!file.exists()) {
                throw new Exception(String.format("module [%s] doesn't exist!", module));
            }
            if (!file.isFile()) {
                throw new Exception(String.format("module [%s] is not a file exist!", module));
            }
            try (FileReader reader = new FileReader(file);){
                cx.evaluateReader((Scriptable)this, (Reader)reader, module, 0, null);
                this.moduleCache.add(module);
                continue;
            }
            catch (IOException e) {
                throw new Exception(String.format("error evaluating module [%s]", module), e);
            }
        }
    }

    public AbstractRhinoTopLevel(Context cx) {
        this(cx, false);
    }

    public AbstractRhinoTopLevel(Context cx, boolean sealed) {
        super(cx, sealed);
    }

    public void initStandardObjects(Context cx, boolean sealed) {
        super.initStandardObjects(cx, sealed);
        String[] names = new String[]{"print", "load"};
        this.defineFunctionProperties(names, ((Object)((Object)this)).getClass(), 2);
        ScriptableObject objProto = (ScriptableObject)AbstractRhinoTopLevel.getObjectPrototype((Scriptable)this);
        objProto.defineFunctionProperties(names, ((Object)((Object)this)).getClass(), 2);
    }
}

