/*
 * Decompiled with CFR 0.152.
 */
package org.javascript.rhino;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.javascript.rhino.JSR223RhinoScriptEngine;
import org.javascript.rhino.JSR223RhinoTopLevel;
import org.mozilla.javascript.Context;

public class JSR223RhinoScriptEngineFactory
implements ScriptEngineFactory {
    private static final String RHINO_VERSION = "1.7.7.1";
    private static final Properties defaults = new Properties();
    private final Properties parameters = new Properties(defaults);

    protected void setParameter(String key, String value) {
        this.parameters.setProperty(key, value);
    }

    public String getName() {
        return (String)this.getParameter("javax.script.name");
    }

    @Override
    public String getEngineName() {
        return (String)this.getParameter("javax.script.engine");
    }

    @Override
    public String getEngineVersion() {
        return (String)this.getParameter("javax.script.engine_version");
    }

    @Override
    public String getLanguageName() {
        return (String)this.getParameter("javax.script.language");
    }

    @Override
    public String getLanguageVersion() {
        return (String)this.getParameter("javax.script.language_version");
    }

    @Override
    public List<String> getExtensions() {
        return Arrays.asList("js");
    }

    @Override
    public List<String> getMimeTypes() {
        return Arrays.asList("application/javascript", "application/ecmascript", "text/javascript", "text/ecmascript");
    }

    @Override
    public Object getParameter(String key) {
        return this.parameters.getProperty(key);
    }

    @Override
    public String getMethodCallSyntax(String obj, String method, String ... args) {
        throw new UnsupportedOperationException("getMethodCallSyntax(String,String,String...)");
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        throw new UnsupportedOperationException("getOutputStatement(String)");
    }

    @Override
    public String getProgram(String ... statements) {
        throw new UnsupportedOperationException("getProgram(String...)");
    }

    @Override
    public List<String> getNames() {
        return Arrays.asList("rhino-npm");
    }

    @Override
    public ScriptEngine getScriptEngine() {
        ClassLoader cl = this.getClass().getClassLoader();
        JSR223RhinoScriptEngine service = new JSR223RhinoScriptEngine(cl, (cx, engine) -> {
            boolean sealed = false;
            return new JSR223RhinoTopLevel((Context)cx, false, (ScriptEngine)engine);
        });
        return service;
    }

    static {
        defaults.setProperty("javax.script.name", "javascript");
        defaults.setProperty("javax.script.engine", "Mozilla Rhino");
        defaults.setProperty("javax.script.engine_version", RHINO_VERSION);
        defaults.setProperty("javax.script.language", "ECMAScript");
        defaults.setProperty("javax.script.language_version", "1.8");
        defaults.setProperty("THREADING", "MULTITHREADED");
    }
}

