/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.agentexecutor.actions;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.output.FinishReason;
import java.util.List;
import java.util.Map;
import org.bsc.langgraph4j.action.NodeAction;
import org.bsc.langgraph4j.agentexecutor.Agent;
import org.bsc.langgraph4j.agentexecutor.AgentExecutor;
import org.bsc.langgraph4j.langchain4j.generators.StreamingChatGenerator;
import org.bsc.langgraph4j.state.AgentState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallAgent
implements NodeAction<AgentExecutor.State> {
    private static final Logger log = LoggerFactory.getLogger(CallAgent.class);
    final Agent agent;

    public CallAgent(Agent agent) {
        this.agent = agent;
    }

    private Map<String, Object> mapResult(ChatResponse response) {
        AiMessage content = response.aiMessage();
        if (response.finishReason() == FinishReason.STOP) {
            return Map.of("agent_response", content.text());
        }
        if (response.finishReason() == FinishReason.TOOL_EXECUTION || content.hasToolExecutionRequests()) {
            return Map.of("messages", content);
        }
        throw new IllegalStateException("Unsupported finish reason: " + String.valueOf(response.finishReason()));
    }

    public Map<String, Object> apply(AgentExecutor.State state) {
        log.trace("callAgent");
        List messages = state.messages();
        if (messages.isEmpty()) {
            throw new IllegalArgumentException("no input provided!");
        }
        if (this.agent.isStreaming()) {
            StreamingChatGenerator generator = StreamingChatGenerator.builder().mapResult(this::mapResult).startingNode("agent").startingState((AgentState)state).build();
            this.agent.execute(messages, generator.handler());
            return Map.of("_generator", generator);
        }
        ChatResponse response = this.agent.execute(messages);
        return this.mapResult(response);
    }
}

