/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.agentexecutor.actions;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.bsc.langgraph4j.action.NodeAction;
import org.bsc.langgraph4j.agentexecutor.AgentExecutor;
import org.bsc.langgraph4j.langchain4j.tool.LC4jToolService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteTools
implements NodeAction<AgentExecutor.State> {
    private static final Logger log = LoggerFactory.getLogger(ExecuteTools.class);
    final LC4jToolService toolNode;

    public ExecuteTools(LC4jToolService toolNode) {
        this.toolNode = Objects.requireNonNull(toolNode, "toolNode cannot be null");
    }

    public Map<String, Object> apply(AgentExecutor.State state) {
        log.trace("executeTools");
        Optional<List> toolExecutionRequests = state.lastMessage().filter(m -> ChatMessageType.AI == m.type()).map(m -> (AiMessage)m).filter(AiMessage::hasToolExecutionRequests).map(AiMessage::toolExecutionRequests);
        if (toolExecutionRequests.isEmpty()) {
            return Map.of("agent_response", "no tool execution request found!");
        }
        List<ToolExecutionResultMessage> result = toolExecutionRequests.get().stream().map(arg_0 -> ((LC4jToolService)this.toolNode).execute(arg_0)).filter(Optional::isPresent).map(Optional::get).toList();
        return Map.of("messages", result);
    }
}

