/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.agentexecutor;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.DefaultChatRequestParameters;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.output.FinishReason;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.bsc.langgraph4j.RunnableConfig;
import org.bsc.langgraph4j.action.AsyncNodeActionWithConfig;
import org.bsc.langgraph4j.agentexecutor.AgentExecutorBuilder;
import org.bsc.langgraph4j.langchain4j.generators.StreamingChatGenerator;
import org.bsc.langgraph4j.prebuilt.MessagesState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallModel<State extends MessagesState<ChatMessage>>
implements AsyncNodeActionWithConfig<State> {
    static final Logger log = LoggerFactory.getLogger(CallModel.class);
    private final ChatModel chatModel;
    private final StreamingChatModel streamingChatModel;
    private final SystemMessage systemMessage;
    final ChatRequestParameters parameters;

    public CallModel(AgentExecutorBuilder<State, ?> builder) {
        this.chatModel = builder.chatModel;
        this.streamingChatModel = builder.streamingChatModel;
        this.systemMessage = Optional.ofNullable(builder.systemMessage).orElseGet(() -> SystemMessage.from((String)"You are a helpful assistant"));
        DefaultChatRequestParameters.Builder parametersBuilder = ChatRequestParameters.builder().toolSpecifications(builder.toolMap().keySet().stream().toList());
        if (builder.responseFormat != null) {
            parametersBuilder.responseFormat(builder.responseFormat);
        }
        this.parameters = parametersBuilder.build();
    }

    public boolean isStreaming() {
        return this.streamingChatModel != null;
    }

    private Map<String, Object> mapResult(ChatResponse response) {
        AiMessage content = response.aiMessage();
        if (response.finishReason() == FinishReason.TOOL_EXECUTION || content.hasToolExecutionRequests()) {
            return Map.of("messages", content);
        }
        if (response.finishReason() == FinishReason.STOP || response.finishReason() == null) {
            String responseText = content.text();
            if (responseText == null) {
                responseText = "";
            }
            return Map.of("agent_response", responseText);
        }
        throw new IllegalStateException("Unsupported finish reason: " + String.valueOf(response.finishReason()));
    }

    private ChatRequest prepareRequest(final List<ChatMessage> messages) {
        ArrayList<ChatMessage> reqMessages = new ArrayList<ChatMessage>(){
            {
                this.add(CallModel.this.systemMessage);
                this.addAll(messages);
            }
        };
        return ChatRequest.builder().messages((List)reqMessages).parameters(this.parameters).build();
    }

    public Map<String, Object> applySync(State state, RunnableConfig config) {
        log.trace("callAgent");
        List messages = state.messages();
        if (messages.isEmpty()) {
            throw new IllegalArgumentException("no input provided!");
        }
        if (this.isStreaming()) {
            StreamingChatGenerator generator = StreamingChatGenerator.builder().mapResult(this::mapResult).startingNode("agent").startingState(state).build();
            this.streamingChatModel.chat(this.prepareRequest(messages), generator.handler());
            return Map.of("_generator", generator);
        }
        ChatResponse response = this.chatModel.chat(this.prepareRequest(messages));
        return this.mapResult(response);
    }

    public CompletableFuture<Map<String, Object>> apply(State state, RunnableConfig config) {
        return CompletableFuture.completedFuture(this.applySync(state, config));
    }
}

