/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.agentexecutor;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.invocation.InvocationContext;
import dev.langchain4j.invocation.InvocationParameters;
import dev.langchain4j.service.tool.ToolExecutor;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.bsc.langgraph4j.GraphStateException;
import org.bsc.langgraph4j.StateGraph;
import org.bsc.langgraph4j.action.AsyncCommandAction;
import org.bsc.langgraph4j.action.Command;
import org.bsc.langgraph4j.agent.Agent;
import org.bsc.langgraph4j.agentexecutor.AgentExecutorBuilder;
import org.bsc.langgraph4j.agentexecutor.CallModel;
import org.bsc.langgraph4j.langchain4j.serializer.jackson.LC4jJacksonStateSerializer;
import org.bsc.langgraph4j.langchain4j.serializer.std.LC4jStateSerializer;
import org.bsc.langgraph4j.langchain4j.tool.LC4jToolService;
import org.bsc.langgraph4j.prebuilt.MessagesState;
import org.bsc.langgraph4j.serializer.StateSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface AgentExecutor {
    public static final Logger log = LoggerFactory.getLogger(AgentExecutor.class);

    public static AsyncCommandAction<State> executeTool(LC4jToolService toolService) {
        return (state, config) -> {
            log.trace("executeTools");
            Optional<List> toolExecutionRequests = state.lastMessage().filter(m -> ChatMessageType.AI == m.type()).map(m -> (AiMessage)m).filter(AiMessage::hasToolExecutionRequests).map(AiMessage::toolExecutionRequests);
            if (toolExecutionRequests.isEmpty()) {
                return CompletableFuture.completedFuture(new Command("end", Map.of("agent_response", "no tool execution request found!")));
            }
            InvocationContext context = InvocationContext.builder().invocationParameters(InvocationParameters.from((Map)state.data())).build();
            return toolService.execute(toolExecutionRequests.get(), context, "messages").thenApply(command -> state.finalResponse().map(res -> new Command("end", command.update())).orElseGet(() -> new Command("agent", command.update())));
        };
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AgentExecutorBuilder<State, Builder> {
        @Deprecated
        public Builder toolSpecification(Object objectsWithTools) {
            super.toolsFromObject(objectsWithTools);
            return this;
        }

        @Deprecated
        public Builder toolSpecification(ToolSpecification spec, ToolExecutor executor) {
            super.tool(spec, executor);
            return this;
        }

        @Deprecated
        public Builder toolSpecification(LC4jToolService.Specification toolSpecification) {
            super.tool(toolSpecification.value(), toolSpecification.executor());
            return this;
        }

        @Override
        public Builder stateSerializer(StateSerializer<State> stateSerializer) {
            this.stateSerializer = stateSerializer;
            return this;
        }

        public StateGraph<State> build() throws GraphStateException {
            if (this.streamingChatModel != null && this.chatModel != null) {
                throw new IllegalArgumentException("chatLanguageModel and streamingChatLanguageModel are mutually exclusive!");
            }
            if (this.streamingChatModel == null && this.chatModel == null) {
                throw new IllegalArgumentException("a chatLanguageModel or streamingChatLanguageModel is required!");
            }
            if (this.stateSerializer == null) {
                this.stateSerializer = Serializers.STD.object();
            }
            LC4jToolService toolService = new LC4jToolService(this.toolMap());
            return Agent.builder().stateSerializer(this.stateSerializer).schema(State.SCHEMA).callModelAction(new CallModel<State>(this)).executeToolsAction(AgentExecutor.executeTool(toolService)).build();
        }
    }

    public static class State
    extends MessagesState<ChatMessage> {
        public static final String FINAL_RESPONSE = "agent_response";

        public State(Map<String, Object> initData) {
            super(initData);
        }

        public Optional<String> finalResponse() {
            return this.value(FINAL_RESPONSE);
        }
    }

    public static enum Serializers {
        STD((StateSerializer<State>)new LC4jStateSerializer(State::new)),
        JSON((StateSerializer<State>)new LC4jJacksonStateSerializer(State::new));

        private final StateSerializer<State> serializer;

        private Serializers(StateSerializer<State> serializer) {
            this.serializer = serializer;
        }

        public StateSerializer<State> object() {
            return this.serializer;
        }
    }
}

