/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.langchain4j.generators;

import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.output.Response;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Function;
import lombok.NonNull;
import org.bsc.async.AsyncGenerator;
import org.bsc.async.AsyncGeneratorQueue;
import org.bsc.langgraph4j.state.AgentState;
import org.bsc.langgraph4j.streaming.StreamingOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LLMStreamingGenerator<T, State extends AgentState>
extends AsyncGenerator.WithResult<StreamingOutput<State>> {
    private static final Logger log = LoggerFactory.getLogger(LLMStreamingGenerator.class);
    final StreamingResponseHandler<T> handler;

    public static <T, State extends AgentState> Builder<T, State> builder() {
        return new Builder();
    }

    private LLMStreamingGenerator(final @NonNull BlockingQueue<AsyncGenerator.Data<StreamingOutput<State>>> queue, final String startingNode, State startingState, Function<Response<T>, Map<String, Object>> mapResult) {
        super((AsyncGenerator)new AsyncGeneratorQueue.Generator(queue));
        if (queue == null) {
            throw new NullPointerException("queue is marked non-null but is null");
        }
        this.handler = new StreamingResponseHandler<T>(){
            final /* synthetic */ AgentState val$startingState;
            final /* synthetic */ Function val$mapResult;
            {
                this.val$startingState = agentState;
                this.val$mapResult = function;
            }

            public void onNext(String token) {
                log.trace("onNext: {}", (Object)token);
                queue.add(AsyncGenerator.Data.of((Object)new StreamingOutput(token, startingNode, this.val$startingState)));
            }

            public void onComplete(Response<T> response) {
                log.trace("onComplete: {}", response);
                queue.add(AsyncGenerator.Data.done(this.val$mapResult.apply(response)));
            }

            public void onError(Throwable error) {
                log.trace("onError", error);
                queue.add(AsyncGenerator.Data.error((Throwable)error));
            }
        };
    }

    public StreamingResponseHandler<T> handler() {
        return this.handler;
    }

    /* synthetic */ LLMStreamingGenerator(BlockingQueue x0, String x1, AgentState x2, Function x3, 1 x4) {
        this(x0, x1, x2, x3);
    }

    public static class Builder<T, State extends AgentState> {
        private BlockingQueue<AsyncGenerator.Data<StreamingOutput<State>>> queue;
        private Function<Response<T>, Map<String, Object>> mapResult;
        private String startingNode;
        private State startingState;

        public Builder<T, State> queue(BlockingQueue<AsyncGenerator.Data<StreamingOutput<State>>> queue) {
            this.queue = queue;
            return this;
        }

        public Builder<T, State> mapResult(Function<Response<T>, Map<String, Object>> mapResult) {
            this.mapResult = mapResult;
            return this;
        }

        public Builder<T, State> startingNode(String node) {
            this.startingNode = node;
            return this;
        }

        public Builder<T, State> startingState(State state) {
            this.startingState = state;
            return this;
        }

        public LLMStreamingGenerator<T, State> build() {
            if (this.queue == null) {
                this.queue = new LinkedBlockingQueue<AsyncGenerator.Data<StreamingOutput<State>>>();
            }
            return new LLMStreamingGenerator(this.queue, this.startingNode, (AgentState)this.startingState, this.mapResult, null);
        }
    }
}

