/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.langchain4j.serializer.jackson;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.UserMessage;
import org.bsc.langgraph4j.langchain4j.serializer.jackson.AiMessageDeserializer;
import org.bsc.langgraph4j.langchain4j.serializer.jackson.AiMessageSerializer;
import org.bsc.langgraph4j.langchain4j.serializer.jackson.SystemMessageDeserializer;
import org.bsc.langgraph4j.langchain4j.serializer.jackson.SystemMessageSerializer;
import org.bsc.langgraph4j.langchain4j.serializer.jackson.UserMessageDeserializer;
import org.bsc.langgraph4j.langchain4j.serializer.jackson.UserMessageSerializer;
import org.bsc.langgraph4j.serializer.plain_text.jackson.JacksonStateSerializer;
import org.bsc.langgraph4j.serializer.plain_text.jackson.TypeMapper;
import org.bsc.langgraph4j.state.AgentState;
import org.bsc.langgraph4j.state.AgentStateFactory;

public class JacksonMessagesStateSerializer<State extends AgentState>
extends JacksonStateSerializer<State> {
    protected JacksonMessagesStateSerializer(AgentStateFactory<State> stateFactory) {
        super(stateFactory);
        SimpleModule module = new SimpleModule();
        ChatMessageSerializer.registerTo(module);
        ChatMessageDeserializer.registerTo(module);
        this.typeMapper.register((TypeMapper.Reference)new TypeMapper.Reference<SystemMessage>(ChatMessageType.SYSTEM.name()){}).register((TypeMapper.Reference)new TypeMapper.Reference<UserMessage>(ChatMessageType.USER.name()){}).register((TypeMapper.Reference)new TypeMapper.Reference<AiMessage>(ChatMessageType.AI.name()){});
        this.objectMapper.registerModule((Module)module);
    }

    static interface ChatMessageSerializer {
        public static final SystemMessageSerializer system = new SystemMessageSerializer();
        public static final UserMessageSerializer user = new UserMessageSerializer();
        public static final AiMessageSerializer ai = new AiMessageSerializer();

        public static void registerTo(SimpleModule module) {
            module.addSerializer(SystemMessage.class, (JsonSerializer)system).addSerializer(UserMessage.class, (JsonSerializer)user).addSerializer(AiMessage.class, (JsonSerializer)ai);
        }
    }

    static interface ChatMessageDeserializer {
        public static final SystemMessageDeserializer system = new SystemMessageDeserializer();
        public static final UserMessageDeserializer user = new UserMessageDeserializer();
        public static final AiMessageDeserializer ai = new AiMessageDeserializer();

        public static void registerTo(SimpleModule module) {
            module.addDeserializer(SystemMessage.class, (JsonDeserializer)system).addDeserializer(UserMessage.class, (JsonDeserializer)user).addDeserializer(AiMessage.class, (JsonDeserializer)ai);
        }
    }
}

