/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.langchain4j.tool;

import dev.langchain4j.agent.tool.Tool;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.agent.tool.ToolSpecifications;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.service.tool.DefaultToolExecutor;
import dev.langchain4j.service.tool.ToolExecutor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LC4jToolService {
    private static final Logger log = LoggerFactory.getLogger(LC4jToolService.class);
    private final List<Specification> entries;

    public static Builder builder() {
        return new Builder();
    }

    LC4jToolService(List<Specification> entries) {
        this.entries = Objects.requireNonNull(entries, "entries cannot be null");
        if (entries.isEmpty()) {
            throw new IllegalArgumentException("entries cannot be empty!");
        }
    }

    public List<ToolSpecification> toolSpecifications() {
        return this.entries.stream().map(Specification::value).collect(Collectors.toList());
    }

    public Optional<ToolExecutionResultMessage> execute(ToolExecutionRequest request, Object memoryId) {
        Objects.requireNonNull(request, "request cannot be null");
        log.trace("execute: {}", (Object)request.name());
        return this.entries.stream().filter(v -> v.value().name().equals(request.name())).findFirst().map(e -> {
            String value = e.executor().execute(request, memoryId);
            return new ToolExecutionResultMessage(request.id(), request.name(), value);
        });
    }

    public Optional<ToolExecutionResultMessage> execute(Collection<ToolExecutionRequest> requests, Object memoryId) {
        Objects.requireNonNull(requests, "requests cannot be null");
        for (ToolExecutionRequest request : requests) {
            Optional<ToolExecutionResultMessage> result = this.execute(request, memoryId);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    public Optional<ToolExecutionResultMessage> execute(ToolExecutionRequest request) {
        return this.execute(request, null);
    }

    public Optional<ToolExecutionResultMessage> execute(Collection<ToolExecutionRequest> requests) {
        return this.execute(requests, null);
    }

    public static class Builder {
        private final List<Specification> toolSpecifications = new ArrayList<Specification>();

        public Builder specification(ToolSpecification spec, ToolExecutor executor) {
            return this.specification(Specification.of(spec, executor));
        }

        public Builder specification(Specification toolSpecifications) {
            this.toolSpecifications.add(toolSpecifications);
            return this;
        }

        public Builder specification(Object objectWithTool) {
            for (Method method : objectWithTool.getClass().getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Tool.class)) continue;
                DefaultToolExecutor toolExecutor = new DefaultToolExecutor(objectWithTool, method);
                this.toolSpecifications.add(new Specification(ToolSpecifications.toolSpecificationFrom((Method)method), (ToolExecutor)toolExecutor));
            }
            return this;
        }

        public LC4jToolService build() {
            return new LC4jToolService(this.toolSpecifications);
        }
    }

    public record Specification(ToolSpecification value, ToolExecutor executor) {
        public static Specification of(ToolSpecification value, ToolExecutor executor) {
            return new Specification(Objects.requireNonNull(value, "value cannot be null"), Objects.requireNonNull(executor, "executor cannot be null"));
        }
    }
}

